/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.luckperms;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import me.lucko.luckperms.LuckPerms;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.User;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="LuckPerms - Permissions of Player")
@Description(value={"Returns the permissions of a player."})
@Examples(value={"send \"%the luckperms permissions of player%\""})
public class ExprPlayerPermissions
extends SimpleExpression<String> {
    private Expression<Player> player;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "luckperms permissions of player";
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.player.getSingle(e) != null) {
            ArrayList<String> perms = new ArrayList<String>();
            for (Node node : LuckPerms.getApi().getUser(((Player)this.player.getSingle(e)).getUniqueId()).getPermissions()) {
                perms.add(node.getPermission());
            }
            return perms.toArray(new String[perms.size()]);
        }
        Skript.error((String)"Must provide a player, please refer to the syntax");
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        User user = LuckPerms.getApi().getUser(((Player)this.player.getSingle(e)).getUniqueId());
        if (mode == Changer.ChangeMode.RESET) {
            user.clearNodes();
        } else if (mode == Changer.ChangeMode.DELETE) {
            user.clearNodes();
        } else if (mode == Changer.ChangeMode.ADD) {
            user.setPermission(LuckPerms.getApi().getNodeFactory().newBuilder((String)delta[0]).build());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            user.unsetPermission(LuckPerms.getApi().getNodeFactory().newBuilder((String)delta[0]).build());
        }
        LuckPerms.getApi().getStorage().saveUser(user);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }
}

