/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopkeepers;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.nisovin.shopkeepers.Shopkeeper;
import com.nisovin.shopkeepers.ShopkeepersPlugin;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Shopkeepers - Does Shopkeeper Exist")
@Description(value={"Checks if a shopkeeper with a certain name exists."})
@Examples(value={"if a shopkeeper named \"cool\" exists:"})
public class CondKeeperExists
extends Condition {
    private Expression<String> keeperName;

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.keeperName = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "keeper name " + (String)this.keeperName.getSingle(e) + " exists";
    }

    public boolean check(Event e) {
        if (this.keeperName.getSingle(e) != null) {
            ShopkeepersPlugin skp = ShopkeepersPlugin.getInstance();
            for (Shopkeeper sk : skp.getAllShopkeepers()) {
                if (!sk.getName().equals(this.keeperName.getSingle(e))) continue;
                return true;
            }
            return false;
        }
        Skript.error((String)"Must provide a string, please refer to the syntax");
        return false;
    }
}

