/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.luckperms;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.lucko.luckperms.LuckPerms;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.Node;
import org.bukkit.event.Event;

@Name(value="LuckPerms - Weight of Group")
@Description(value={"Returns the weight of a group."})
@Examples(value={"set {default::weight} to the weight of the luckperms group \"default\""})
public class ExprGroupWeight
extends SimpleExpression<Number> {
    private Expression<String> group;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.group = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "luckperms weight of group";
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.group.getSingle(e) != null) {
            if (LuckPerms.getApi().getGroup((String)this.group.getSingle(e)).getWeight().isPresent()) {
                return new Number[]{LuckPerms.getApi().getGroup((String)this.group.getSingle(e)).getWeight().getAsInt()};
            }
            return new Number[]{0};
        }
        Skript.error((String)"Must provide a string, please refer to the syntax");
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Group groupBeingChanged = LuckPerms.getApi().getGroup((String)this.group.getSingle(e));
        if (mode == Changer.ChangeMode.SET) {
            for (Node node : groupBeingChanged.getPermissions()) {
                if (!node.getPermission().split("\\.")[0].equalsIgnoreCase("weight")) continue;
                groupBeingChanged.unsetPermission(node);
            }
            groupBeingChanged.setPermission(LuckPerms.getApi().getNodeFactory().newBuilder("weight." + String.valueOf(delta[0])).build());
            LuckPerms.getApi().getStorage().saveGroup(groupBeingChanged);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

