/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.intellectualcrafters.plot.api.PlotAPI;
import com.intellectualcrafters.plot.object.Plot;
import com.intellectualcrafters.plot.object.PlotId;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="PlotSquared - Denied Players of Plot")
@Description(value={"Returns the denied players of a plot."})
@Examples(value={"send \"%the denied players of the plot with id (id of plot at player)%\""})
public class ExprDenied
extends SimpleExpression<OfflinePlayer> {
    private PlotAPI plot = new PlotAPI();
    private Expression<String> id;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "denied players of plot with id " + (String)this.id.getSingle(e);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        if (this.id.getSingle(e) != null) {
            ArrayList<OfflinePlayer> denied = new ArrayList<OfflinePlayer>();
            PlotId plotId = PlotId.fromString((String)((String)this.id.getSingle(e)));
            if (plotId == null) {
                Skript.error((String)"Invalid plot ID, please refer to the syntax");
                return null;
            }
            for (Plot aPlot : this.plot.getAllPlots()) {
                if (!aPlot.getId().equals((Object)plotId)) continue;
                for (UUID p : aPlot.getDenied()) {
                    denied.add(Bukkit.getOfflinePlayer((UUID)p));
                }
                return denied.toArray(new OfflinePlayer[denied.size()]);
            }
            Skript.error((String)"Invalid plot ID, please refer to the syntax");
            return null;
        }
        Skript.error((String)"Must provide a location, please refer to the syntax");
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        block3: {
            OfflinePlayer player;
            block2: {
                player = (OfflinePlayer)delta[0];
                if (mode != Changer.ChangeMode.ADD) break block2;
                PlotId plotId = PlotId.fromString((String)((String)this.id.getSingle(e)));
                for (Plot aPlot : this.plot.getAllPlots()) {
                    if (!aPlot.getId().equals((Object)plotId)) continue;
                    aPlot.addDenied(player.getUniqueId());
                }
                break block3;
            }
            if (mode != Changer.ChangeMode.REMOVE) break block3;
            PlotId plotId = PlotId.fromString((String)((String)this.id.getSingle(e)));
            for (Plot aPlot : this.plot.getAllPlots()) {
                if (!aPlot.getId().equals((Object)plotId)) continue;
                aPlot.removeDenied(player.getUniqueId());
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class});
        }
        return null;
    }
}

