/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.minepacks;

import at.pcgamingfreaks.MinePacks.MinePacks;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="MinePacks - Backpack SLot")
@Description(value={"Returns the item in a backpack slot."})
@Examples(value={"send \"%the item in slot 5 of backpack of player%\""})
public class ExprSlotItem
extends SimpleExpression<ItemStack> {
    private MinePacks mp = MinePacks.getInstance();
    private Expression<Integer> slotNum;
    private Expression<Player> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.slotNum = e[0];
        this.player = e[1];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "item in slot " + this.slotNum + " of backpack of player " + this.player.getSingle(e);
    }

    @Nullable
    protected ItemStack[] get(Event e) {
        if (this.player.getSingle(e) != null) {
            if (this.slotNum != null) {
                return new ItemStack[]{this.mp.DB.getBackpack((OfflinePlayer)this.player.getSingle(e)).getInventory().getItem(((Integer)this.slotNum.getSingle(e)).intValue())};
            }
            Skript.error((String)"Must provide an integer, please refer to the syntax");
            return null;
        }
        Skript.error((String)"Must provide a player, please refer to the syntax");
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            this.mp.DB.getBackpack((OfflinePlayer)this.player.getSingle(e)).getInventory().setItem(((Integer)this.slotNum.getSingle(e)).intValue(), (ItemStack)delta[0]);
            this.mp.DB.getBackpack((OfflinePlayer)this.player.getSingle(e)).save();
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ItemStack.class});
        }
        return null;
    }
}

