/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.advancedsurvivalgames;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import e.Game;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="AdvancedSurvivalGames - Bounty")
@Description(value={"Returns the bounty of a player."})
@Examples(value={"send \"Your bounty: %survival games bounty of player%\""})
public class ExprBounty
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "the survival games bounty of player" + this.player.getSingle(e);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) != null) {
            return new Number[]{Game.getPlayerManager().getSGPlayer((OfflinePlayer)this.player.getSingle(e)).getBounty()};
        }
        Skript.error((String)"Must provide a player, please refer to the syntax");
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Number bountyChange = (Number)delta[0];
        Integer currentBounty = Game.getPlayerManager().getSGPlayer((OfflinePlayer)this.player.getSingle(e)).getBounty();
        if (mode == Changer.ChangeMode.SET) {
            Game.getPlayerManager().getSGPlayer((OfflinePlayer)this.player.getSingle(e)).setBounty(bountyChange.intValue());
        } else if (mode == Changer.ChangeMode.ADD) {
            Game.getPlayerManager().getSGPlayer((OfflinePlayer)this.player.getSingle(e)).setBounty(currentBounty + bountyChange.intValue());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            Game.getPlayerManager().getSGPlayer((OfflinePlayer)this.player.getSingle(e)).setBounty(currentBounty - bountyChange.intValue());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

