/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.bitcoin;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.bitcoin.Bitcoin;

@Name(value="Bitcoin - Amount In Bank")
@Description(value={"Returns the amount of bitcoins in the bank."})
@Examples(value={"send \"%the amount of bitcoins in the bank%\""})
public class ExprAmountInBank
extends SimpleExpression<Number> {
    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "the amount of bitcoins in the bank";
    }

    @Nullable
    protected Number[] get(Event e) {
        return new Number[]{Bitcoin.getAPI().getAmountInBank()};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Number amount = (Number)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            Bitcoin.getAPI().addToBank(amount.doubleValue() - Bitcoin.getAPI().getAmountInBank());
        } else if (mode == Changer.ChangeMode.ADD) {
            Bitcoin.getAPI().addToBank(amount.doubleValue());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            Bitcoin.getAPI().removeFromBank(amount.doubleValue());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

