/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.playerpoints;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="PlayerPoints - Balance")
@Description(value={"Returns the PlayerPoints balance of a player."})
@Examples(value={"send \"%the player points balance of player%\""})
public class ExprPointsBalance
extends SimpleExpression<Number> {
    private PlayerPointsAPI playerPointsAPI = ((PlayerPoints)Bukkit.getServer().getPluginManager().getPlugin("PlayerPoints")).getAPI();
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "the player points balance of player " + this.player.getSingle(e);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) != null) {
            return new Number[]{this.playerPointsAPI.look(((OfflinePlayer)this.player.getSingle(e)).getUniqueId())};
        }
        Skript.error((String)"Must provide a player, please refer to the syntax");
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Number amount = (Number)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            this.playerPointsAPI.set(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount.intValue());
        } else if (mode == Changer.ChangeMode.ADD) {
            this.playerPointsAPI.give(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount.intValue());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            this.playerPointsAPI.take(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount.intValue());
        } else if (mode == Changer.ChangeMode.RESET) {
            this.playerPointsAPI.reset(((OfflinePlayer)this.player.getSingle(e)).getUniqueId());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

