/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.parties;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.alessiodp.parties.Parties;
import com.alessiodp.parties.utils.api.PartiesAPI;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Parties - Party Kills")
@Description(value={"Returns the amount of kills of a party."})
@Examples(value={"send \"%the kills of the party named \"cool\"%\""})
public class ExprKills
extends SimpleExpression<Number> {
    PartiesAPI parties = new PartiesAPI();
    private Expression<String> name;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "kills of party named " + (String)this.name.getSingle(e);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.name.getSingle(e) != null) {
            return new Number[]{this.parties.getPartyKills((String)this.name.getSingle(e))};
        }
        Skript.error((String)"Must provide a string, please refer to the syntax");
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Number killsChange = (Number)delta[0];
        Integer currentKills = this.parties.getPartyKills((String)this.name.getSingle(e));
        if (mode == Changer.ChangeMode.SET) {
            Parties.getInstance().getPartyHandler().loadParty((String)this.name.getSingle(e)).setKills(killsChange.intValue());
        } else if (mode == Changer.ChangeMode.ADD) {
            Parties.getInstance().getPartyHandler().loadParty((String)this.name.getSingle(e)).setKills(currentKills + killsChange.intValue());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            Parties.getInstance().getPartyHandler().loadParty((String)this.name.getSingle(e)).setKills(currentKills - killsChange.intValue());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

