/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.lockette;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.yi.acru.bukkit.Lockette.Lockette;

@Name(value="Lockette - Block Owner")
@Description(value={"Returns the owner of a block."})
@Examples(value={"send \"%owner of the clicked block%\""})
public class ExprOwner
extends SimpleExpression<Player> {
    private Expression<Block> block;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.block = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "owner of block " + this.block.getSingle(e);
    }

    @Nullable
    protected Player[] get(Event e) {
        if (this.block.getSingle(e) != null) {
            if (!Lockette.isProtected((Block)((Block)this.block.getSingle(e)))) {
                return null;
            }
            Player player = Bukkit.getPlayer((String)Lockette.getProtectedOwner((Block)((Block)this.block.getSingle(e))));
            return new Player[]{player};
        }
        Skript.error((String)"Must provide a block, please refer to the syntax");
        return null;
    }
}

