/*
 * Decompiled with CFR 0.152.
 */
package me.TheBukor.SkStuff.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import javax.annotation.Nullable;
import me.TheBukor.SkStuff.SkStuff;
import me.TheBukor.SkStuff.util.ReflectionUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprNBTOf
extends SimpleExpression<Object> {
    private Expression<Object> target;
    private Class<?> nbtClass = ReflectionUtils.getNMSClass("NBTTagCompound");

    public Class<? extends Object> getReturnType() {
        return this.nbtClass;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult result) {
        this.target = expr[0];
        Class type = this.target.getReturnType();
        if (type != Entity.class || type != Block.class || type != ItemStack.class || type != Slot.class) {
            Skript.error((String)(this.target.toString() + " is neither an entity, a block nor an itemstack."), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the NBT of " + this.target.toString(e, debug);
    }

    @Nullable
    public Object[] get(Event e) {
        Object tar = this.target.getSingle(e);
        if (tar instanceof Entity) {
            return new Object[]{SkStuff.getNMSMethods().getEntityNBT((Entity)tar)};
        }
        if (tar instanceof Block) {
            return new Object[]{SkStuff.getNMSMethods().getTileNBT((Block)tar)};
        }
        if (tar instanceof ItemStack) {
            return new Object[]{SkStuff.getNMSMethods().getItemNBT((ItemStack)tar)};
        }
        if (tar instanceof Slot) {
            return new Object[]{SkStuff.getNMSMethods().getItemNBT(((Slot)tar).getItem())};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object tar = this.target.getSingle(e);
        Object parsedNBT = null;
        if (delta != null) {
            parsedNBT = SkStuff.getNMSMethods().parseRawNBT((String)delta[0]);
        }
        if (tar instanceof Entity) {
            Object entNBT = SkStuff.getNMSMethods().getEntityNBT((Entity)tar);
            if (mode == Changer.ChangeMode.ADD) {
                SkStuff.getNMSMethods().removeFromCompound(parsedNBT, "UUIDMost", "UUIDLeast", "WorldUUDMost", "WorldUUIDLeast", "Bukkit.updateLevel");
                SkStuff.getNMSMethods().addToCompound(entNBT, parsedNBT);
                SkStuff.getNMSMethods().setEntityNBT((Entity)tar, entNBT);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                for (Object s : delta) {
                    if (s == "UUIDMost" && s == "UUIDLeast" && s == "WorldUUIDMost" && s == "WorldUUIDLeast" && s == "Bukkit.updateLevel") continue;
                    SkStuff.getNMSMethods().removeFromCompound(entNBT, (String)s);
                }
                SkStuff.getNMSMethods().setEntityNBT((Entity)tar, entNBT);
            }
        } else if (tar instanceof Block) {
            Object blockNBT = SkStuff.getNMSMethods().getTileNBT((Block)tar);
            if (mode == Changer.ChangeMode.ADD) {
                SkStuff.getNMSMethods().removeFromCompound(parsedNBT, "x", "y", "z", "id");
                SkStuff.getNMSMethods().addToCompound(blockNBT, parsedNBT);
                SkStuff.getNMSMethods().setTileNBT((Block)tar, blockNBT);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                for (Object s : delta) {
                    if (s == "x" && s == "y" && s == "z" && s == "id") continue;
                    SkStuff.getNMSMethods().removeFromCompound(blockNBT, (String)s);
                }
                SkStuff.getNMSMethods().setTileNBT((Block)tar, blockNBT);
            }
        } else if (tar instanceof ItemStack) {
            if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                Skript.warning((String)"Failed to change the NBT of an item: Itemstack didn't have any slot attached to it.");
            }
        } else if (tar instanceof Slot) {
            ItemStack slotItem = ((Slot)tar).getItem();
            Object itemNBT = SkStuff.getNMSMethods().getItemNBT(slotItem);
            if (mode == Changer.ChangeMode.ADD) {
                SkStuff.getNMSMethods().addToCompound(itemNBT, parsedNBT);
                ItemStack newItem = SkStuff.getNMSMethods().getItemWithNBT(slotItem, itemNBT);
                ((Slot)tar).setItem(newItem);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                String[] toRemove = (String[])Arrays.copyOf(delta, delta.length, String[].class);
                SkStuff.getNMSMethods().removeFromCompound(itemNBT, toRemove);
                ItemStack newItem = SkStuff.getNMSMethods().getItemWithNBT(slotItem, itemNBT);
                ((Slot)tar).setItem(newItem);
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                ItemStack newItem = SkStuff.getNMSMethods().getItemWithNBT(slotItem, null);
                ((Slot)tar).setItem(newItem);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String[].class});
        }
        return null;
    }
}

