/*
 * Decompiled with CFR 0.152.
 */
package me.TheBukor.SkStuff.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffPasteSchematic
extends Effect {
    private Expression<String> schematic;
    private Expression<Location> location;
    private Expression<EditSession> editSession;
    private int mark;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult result) {
        this.mark = result.mark;
        this.schematic = expr[0];
        this.location = expr[1];
        this.editSession = expr[2];
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "paste schematic " + this.schematic.toString(e, debug) + " at " + this.location.toString(e, debug) + " using edit session" + (this.mark == 1 ? " ignoring air" : "");
    }

    protected void execute(Event e) {
        File schemFile;
        String schem = (String)this.schematic.getSingle(e);
        Location loc = (Location)this.location.getSingle(e);
        EditSession session = (EditSession)this.editSession.getSingle(e);
        Vector origin = BukkitUtil.toVector((Location)loc);
        boolean noAir = false;
        if (this.mark == 1) {
            noAir = true;
        }
        if (!(schemFile = new File(schem.endsWith(".schematic") ? schem : schem + ".schematic")).exists() || session == null) {
            return;
        }
        try {
            SchematicFormat.getFormat((File)schemFile).load(schemFile).paste(session, origin, noAir);
        }
        catch (MaxChangedBlocksException | DataException | IOException ex) {
            if (ex instanceof MaxChangedBlocksException) {
                return;
            }
            ex.printStackTrace();
        }
    }
}

