/*
 * Decompiled with CFR 0.152.
 */
package me.TheBukor.SkStuff.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.pattern.Patterns;
import com.sk89q.worldedit.function.pattern.RandomPattern;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class EffMakeSphere
extends Effect {
    private Expression<Location> location;
    private Expression<Double> radius1;
    private Expression<Double> radius2;
    private Expression<Double> radius3;
    private Expression<EditSession> editSession;
    private Expression<ItemStack> blockList;
    private boolean filled = true;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult result) {
        this.location = expr[0];
        this.radius1 = expr[1];
        this.radius2 = expr[2];
        this.radius3 = expr[3];
        this.editSession = expr[4];
        this.blockList = expr[5];
        if (result.mark == 1) {
            this.filled = false;
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "create a sphere centered at " + this.location.toString(e, debug) + " with a radius of " + this.radius1.toString(e, debug) + " " + this.radius2.toString(e, debug) + " " + this.radius3.toString(e, debug) + " using an edit session with " + this.blockList.toString(e, debug);
    }

    protected void execute(Event e) {
        Location loc = (Location)this.location.getSingle(e);
        Double rad1 = (Double)this.radius1.getSingle(e);
        Double rad2 = (Double)this.radius2.getSingle(e);
        Double rad3 = (Double)this.radius3.getSingle(e);
        EditSession session = (EditSession)this.editSession.getSingle(e);
        ItemStack[] blocks = (ItemStack[])this.blockList.getAll(e);
        RandomPattern random = new RandomPattern();
        if (session == null) {
            return;
        }
        for (ItemStack b : blocks) {
            if (!b.getType().isBlock()) continue;
            random.add((Pattern)new BlockPattern(new BaseBlock(b.getTypeId(), (int)b.getDurability())), 50.0);
        }
        try {
            session.makeSphere(BukkitUtil.toVector((Location)loc), Patterns.wrap((Pattern)random), rad1.doubleValue(), rad2.doubleValue(), rad3.doubleValue(), this.filled);
            session.flushQueue();
        }
        catch (WorldEditException ex) {
            if (ex instanceof MaxChangedBlocksException) {
                return;
            }
            ex.printStackTrace();
        }
    }
}

