/*
 * Decompiled with CFR 0.152.
 */
package me.TheBukor.SkStuff;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import ch.njol.util.coll.CollectionUtils;
import com.sk89q.worldedit.EditSession;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import me.TheBukor.SkStuff.conditions.CondSelectionContains;
import me.TheBukor.SkStuff.effects.EffClearPathGoals;
import me.TheBukor.SkStuff.effects.EffDrainLiquid;
import me.TheBukor.SkStuff.effects.EffDrawLineWE;
import me.TheBukor.SkStuff.effects.EffMakeCylinder;
import me.TheBukor.SkStuff.effects.EffMakeJump;
import me.TheBukor.SkStuff.effects.EffMakePyramid;
import me.TheBukor.SkStuff.effects.EffMakeSphere;
import me.TheBukor.SkStuff.effects.EffMakeWalls;
import me.TheBukor.SkStuff.effects.EffNaturalize;
import me.TheBukor.SkStuff.effects.EffPasteSchematic;
import me.TheBukor.SkStuff.effects.EffRememberChanges;
import me.TheBukor.SkStuff.effects.EffRemovePathGoal;
import me.TheBukor.SkStuff.effects.EffReplaceBlocksWE;
import me.TheBukor.SkStuff.effects.EffSetBlocksWE;
import me.TheBukor.SkStuff.effects.EffSetPathGoal;
import me.TheBukor.SkStuff.effects.EffShowEntityEffect;
import me.TheBukor.SkStuff.effects.EffSimulateSnow;
import me.TheBukor.SkStuff.effects.EffToggleVanish;
import me.TheBukor.SkStuff.effects.EffUndoRedoSession;
import me.TheBukor.SkStuff.events.EvtWorldEditChange;
import me.TheBukor.SkStuff.events.WorldEditChangeHandler;
import me.TheBukor.SkStuff.expressions.ExprChangedBlocksSession;
import me.TheBukor.SkStuff.expressions.ExprClickedInventory;
import me.TheBukor.SkStuff.expressions.ExprEditSessionLimit;
import me.TheBukor.SkStuff.expressions.ExprEndermanBlocks;
import me.TheBukor.SkStuff.expressions.ExprFileNBT;
import me.TheBukor.SkStuff.expressions.ExprFireProof;
import me.TheBukor.SkStuff.expressions.ExprItemNBT;
import me.TheBukor.SkStuff.expressions.ExprNBTOf;
import me.TheBukor.SkStuff.expressions.ExprNewEditSession;
import me.TheBukor.SkStuff.expressions.ExprNoClip;
import me.TheBukor.SkStuff.expressions.ExprSchematicArea;
import me.TheBukor.SkStuff.expressions.ExprSelectionArea;
import me.TheBukor.SkStuff.expressions.ExprSelectionOfPlayer;
import me.TheBukor.SkStuff.expressions.ExprSelectionPos;
import me.TheBukor.SkStuff.expressions.ExprTagOf;
import me.TheBukor.SkStuff.expressions.ExprTimespanToNumber;
import me.TheBukor.SkStuff.expressions.ExprToLowerCase;
import me.TheBukor.SkStuff.expressions.ExprToUpperCase;
import me.TheBukor.SkStuff.expressions.ExprVanishState;
import me.TheBukor.SkStuff.expressions.ExprWordsToUpperCase;
import me.TheBukor.SkStuff.util.NBTUtil;
import me.TheBukor.SkStuff.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkStuff
extends JavaPlugin {
    private int condAmount = 0;
    private int effAmount = 0;
    private int evtAmount = 0;
    private int exprAmount = 0;
    private int typeAmount = 0;
    private Class<?> nbtClass = ReflectionUtils.getNMSClass("NBTTagCompound", false);
    private Class<?> nbtListClass = ReflectionUtils.getNMSClass("NBTTagList", false);
    private Class<?> nbtArrayClass = ReflectionUtils.getNMSClass("NBTTagCompound", true);
    private Class<?> nbtParserClass = ReflectionUtils.getNMSClass("MojangsonParser", false);

    public void onEnable() {
        if (Bukkit.getPluginManager().getPlugin("Skript") != null && Skript.isAcceptRegistrations()) {
            Skript.registerAddon((JavaPlugin)this);
            this.getLogger().info("SkStuff " + this.getDescription().getVersion() + " has been successfully enabled!");
            this.getLogger().info("Registering general non version specific stuff...");
            Skript.registerExpression(ExprToUpperCase.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%string% [converted] to [all] (cap[ital]s|upper[ ]case)", "convert %string% to [all] (cap[ital]s|upper[ ]case)", "capitalize [all] [char[acter]s (of|in)] %string%"});
            Skript.registerExpression(ExprToLowerCase.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%string% [converted] to [all] lower[ ]case", "convert %string% to [all] lower[ ]case", "un[( |-)]capitalize [all] [char[acter]s (of|in)] %string%"});
            Skript.registerExpression(ExprWordsToUpperCase.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"(first|1st) (letter|char[acter]) (of|in) (each word|[all] words) (of|in) %string% [converted] to (cap[ital]s|upper[ ]case) (0\u00a6|1\u00a6ignoring [other] upper[ ]case [(char[acter]s|letters)])", "convert (first|1st) (letter|char[acter]) (of|in) (each word|[all] words) (of|in) %string% to (cap[ital]s|upper[ ]case) (0\u00a6|1\u00a6ignoring [other] upper[ ]case [(char[acter]s|letters)])", "capitalize (first|1st) (letter|char[acter]) (of|in) (each word|[all] words) (of|in) %string% (0\u00a6|1\u00a6ignoring [other] upper[ ]case [(char[acter]s|letters)])"});
            Skript.registerExpression(ExprTimespanToNumber.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%timespan% [converted] [in]to (0\u00a6ticks|1\u00a6sec[ond]s|2\u00a6min[ute]s|3\u00a6hours|4\u00a6days)"});
            Skript.registerExpression(ExprClickedInventory.class, Inventory.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[skstuff] clicked inventory"});
            this.exprAmount += 5;
            this.getLogger().info("Trying to register version specific stuff...");
            Skript.registerEffect(EffClearPathGoals.class, (String[])new String[]{"(clear|delete) [all] pathfind[er] goals (of|from) %livingentity%"});
            Skript.registerEffect(EffRemovePathGoal.class, (String[])new String[]{"remove pathfind[er] goal (0\u00a6(avoid|run away from) entit(y|ies)|1\u00a6break door[s]|2\u00a6breed|3\u00a6eat grass|4\u00a6(flee from the sun|seek shad(e|ow))|5\u00a6float (in[side]|on) water|6\u00a6follow (owner|tamer)|7\u00a6follow (adult|parent)[s]|8\u00a6(fight back|react to|target) (damager|attacker)|9\u00a6o(c|z)elot jump on blocks|10\u00a6leap at target|11\u00a6look at entit(y|ies)|12\u00a6melee attack entit(y|ies)|13\u00a6move to[wards] target|14\u00a6target nearest entity|15\u00a6o(c|z)elot attack [chicken[s]]|16\u00a6open door[s]|17\u00a6(panic|flee)|18\u00a6look around randomly|19\u00a6(walk around randomly|wander)|20\u00a6sit|21\u00a6[creeper] (explode|inflate|swell)|22\u00a6squid (swim|wander)|23\u00a6shoot fireball[s]|24\u00a6[silverfish] hide (in[side]|on) block[s]|25\u00a6(wake other silverfish[es]|[silverfish] call (help|reinforcement|other [hidden] silverfish[es]))|26\u00a6[enderm(a|e)n] pick[[ ]up] block[s]|27\u00a6[enderm(a|e)n] place block[s]|28\u00a6[enderman] attack player (staring|looking) [at eye[s]]|29\u00a6ghast move to[wards] target|30\u00a6ghast (idle move[ment]|wander|random fl(ight|y[ing]))|31\u00a6(tempt to|follow players (holding|with)) [a[n]] item|32\u00a6target [random] entity (if|when) (not tamed|untamed)|33\u00a6guardian attack [entity]|34\u00a6[z[ombie[ ]]pig[man]] attack [player[s]] (if|when) angry|35\u00a6[z[ombie[ ]]pig[man]] (react to|fight back|target) (attacker|damager) (if|when) angry|36\u00a6[rabbit] eat carrot crops|37\u00a6[killer] rabbit [melee] attack|38\u00a6slime [random] jump|39\u00a6slime change (direction|facing) randomly|40\u00a6slime (idle move[ment]|wander)) from %livingentity%"});
            Skript.registerEffect(EffSetPathGoal.class, (String[])new String[]{"add pathfind[er] goal [[with] priority %-integer%] (0\u00a6(avoid|run away from) %entitydata%[, radius %-number%[, speed %-number%[, speed (if|when) (close|near) %-number%]]]|1\u00a6break door[s]|2\u00a6breed[,[move[ment]] speed %-number%]|3\u00a6eat grass|4\u00a6(flee from the sun|seek shad(e|ow))[, [move[ment]] speed %-number%]|5\u00a6(float (in[side]|on) water|swim)|6\u00a6follow (owner|tamer)[, speed %-number%[, min[imum] distance %-number%[, max[imum] distance %-number%]]]|7\u00a6follow (adult|parent)[s][, [move[ment]] speed %-number%]|8\u00a6(fight back|react to|target) (damager|attacker) [[of] type] %entitydata%[, call ([for] help|reinforcement) %-boolean%]|9\u00a6o(c|z)elot jump on blocks[, [move[ment]] speed %-number%]|10\u00a6leap at target[, [leap] height %-number%]|11\u00a6look at %entitydata%[, (radius|max[imum] distance) %-number%]|12\u00a6melee attack %entitydata%[, [move[ment]] speed %-number%[, (memorize|do('nt| not) forget) target [for [a] long[er] time] %-boolean%]]|13\u00a6move to[wards] target[, [move[ment]] speed %-number%[, (radius|max[imum] distance) %-number%]]|14\u00a6target nearest [entity [of] type] %entitydata%[, check sight %-boolean%]|15\u00a6o(c|z)elot attack|16\u00a6open door[s]|17\u00a6(panic|flee)[, [move[ment]] speed %-number%]|18\u00a6look around randomly|19\u00a6(walk around randomly|wander)[, [move[ment]] speed %-number%[, min[imum] [of] %-timespan% between mov(e[ment][s]|ing)]]|20\u00a6sit|21\u00a6[creeper] (explode|inflate|swell)|22\u00a6squid (swim around|wander)|23\u00a6shoot fireball[s]|24\u00a6[silverfish] hide (in[side]|on) block[s]|25\u00a6((call|summon|wake) [other] [hidden] silverfish[es])|26\u00a6[enderman] pick[[ ]up] block[s]|27\u00a6[enderman] place block[s]|28\u00a6[enderman] attack player (staring|looking) at [their] eye[s]]|29\u00a6ghast move to[wards] target|30\u00a6ghast (idle move[ment]|wander|random fl(ight|y[ing]))|31\u00a6(tempt to|follow players (holding|with)) %-itemstack%[, [move[ment]] speed %number%[, scared of player movement %-boolean%]]|32\u00a6target [random] %entitydata% (if|when) (not |un)tamed|33\u00a6guardian attack [entities]|34\u00a6[z[ombie[ ]]pig[man]] attack [player[s]] (if|when) angry|35\u00a6[z[ombie[ ]]pig[man]] (react to|fight back|target) (attacker|damager) (if|when) angry|36\u00a6[rabbit] eat carrot crops|37\u00a6[killer] rabbit [melee] attack|38\u00a6slime [random] jump|39\u00a6slime change (direction|facing) randomly|40\u00a6slime (idle move[ment]|wander)) to %livingentity%"});
            Skript.registerEffect(EffMakeJump.class, (String[])new String[]{"make %livingentities% jump", "force %livingentities% to jump"});
            Skript.registerEffect(EffShowEntityEffect.class, (String[])new String[]{"(display|play|show) entity effect (0\u00a6firework[s] explo(de|sion)|1\u00a6hurt|2\u00a6[[iron] golem] (give|offer) (rose|poppy)|3\u00a6[sheep] eat grass|4\u00a6wolf shake) at %entity%"});
            Skript.registerExpression(ExprNBTOf.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"nbt[[ ]tag[s]] of %object%", "%object%'s nbt[[ ]tag[s]]"});
            Skript.registerExpression(ExprItemNBT.class, ItemStack.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%itemstack% with [custom] nbt[[ ]tag[s]] %string%"});
            Skript.registerExpression(ExprTagOf.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[nbt[ ]]tag %string% of [[nbt] compound] %compound%"});
            Skript.registerExpression(ExprFileNBT.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"nbt[[ ]tag[s]] from [file] %string%"});
            Skript.registerExpression(ExprNoClip.class, Boolean.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"no[( |-)]clip (state|mode) of %entities%", "%entities%'s no[( |-)]clip (state|mode)"});
            Skript.registerExpression(ExprFireProof.class, Boolean.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"fire[ ]proof (state|mode) of %entities%", "%entities%'s fire[ ]proof (state|mode)"});
            Skript.registerExpression(ExprEndermanBlocks.class, ItemStack.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"blocks that %entity% can (carry|hold|grab|steal)"});
            Classes.registerClass((ClassInfo)new ClassInfo(this.nbtClass, "compound").user(new String[]{"((nbt)?( ?tag)?) ?compounds?"}).name("NBT Compound").changer((Changer)new Changer<Object>(){

                @Nullable
                public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                    if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
                        return (Class[])CollectionUtils.array((Object[])new Class[]{String[].class, SkStuff.this.nbtArrayClass});
                    }
                    return null;
                }

                public void change(Object[] NBT, @Nullable Object[] delta, Changer.ChangeMode mode) {
                    if (NBT[0].getClass().getName().contains("NBTTagCompound")) {
                        if (!(delta[0] instanceof String) || !delta[0].getClass().isInstance(SkStuff.this.nbtClass)) {
                            return;
                        }
                        String newTags = (String)delta[0];
                        if (mode == Changer.ChangeMode.SET) {
                            if (!(delta[0] instanceof String)) {
                                NBT[0] = delta[0];
                            }
                        } else if (mode == Changer.ChangeMode.ADD) {
                            if (delta[0] instanceof String) {
                                Object NBT1 = null;
                                try {
                                    NBT1 = SkStuff.this.nbtParserClass.getMethod("parse", String.class).invoke(NBT1, newTags);
                                }
                                catch (Exception ex) {
                                    if (ex instanceof InvocationTargetException && ex.getCause().getClass().getName().contains("MojangsonParseException")) {
                                        SkStuff.this.getLogger().warning("Error when parsing NBT - " + ex.getCause().getMessage());
                                        return;
                                    }
                                    ex.printStackTrace();
                                }
                                NBTUtil.addCompound(NBT[0], NBT1);
                            } else {
                                NBTUtil.addCompound(NBT[0], delta[0]);
                            }
                        } else if (mode == Changer.ChangeMode.REMOVE) {
                            if (!(delta[0] instanceof String)) {
                                return;
                            }
                            Object[] objectArray = delta;
                            int n = delta.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object s = objectArray[n2];
                                try {
                                    SkStuff.this.nbtClass.getMethod("remove", String.class).invoke(NBT[0], (String)s);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                ++n2;
                            }
                        }
                    }
                }
            }).parser((Parser)new Parser<Object>(){

                public String getVariableNamePattern() {
                    return ".+";
                }

                @Nullable
                public Object parse(String rawNBT, ParseContext context) {
                    if (rawNBT.startsWith("nbt:{") && rawNBT.endsWith("}")) {
                        Object NBT = null;
                        try {
                            NBT = SkStuff.this.nbtParserClass.getMethod("parse", String.class).invoke(NBT, rawNBT);
                        }
                        catch (Exception ex) {
                            if (ex instanceof InvocationTargetException && ex.getCause().getClass().getName().contains("MojangsonParseException")) {
                                return null;
                            }
                            ex.printStackTrace();
                        }
                        if (NBT.toString().equals("{}") || NBT == null) {
                            return null;
                        }
                        return NBT;
                    }
                    return null;
                }

                public String toString(Object compound, int arg1) {
                    return compound.toString();
                }

                public String toVariableNameString(Object compound) {
                    return "nbt:" + compound.toString();
                }
            }));
            Classes.registerClass((ClassInfo)new ClassInfo(this.nbtListClass, "nbtlist").user(new String[]{"nbt ?list ?(tag)?"}).name("NBT List").changer((Changer)new Changer<Object>(){

                @Nullable
                public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                    if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                        return (Class[])CollectionUtils.array((Object[])new Class[]{Float[].class, Double[].class, String[].class, SkStuff.this.nbtArrayClass, Integer[].class});
                    }
                    return null;
                }

                public void change(Object[] list, @Nullable Object[] delta, Changer.ChangeMode mode) {
                    if (list[0].getClass().getName().contains("NBTTagList")) {
                        int typeId = 0;
                        if (delta instanceof Float[]) {
                            typeId = 5;
                        } else if (delta instanceof Double[]) {
                            typeId = 6;
                        } else if (delta instanceof String[]) {
                            typeId = 8;
                        } else if (delta.getClass() == SkStuff.this.nbtArrayClass) {
                            typeId = 10;
                        } else if (delta instanceof Integer[]) {
                            typeId = 11;
                        } else {
                            return;
                        }
                        if (mode == Changer.ChangeMode.SET) {
                            if (NBTUtil.getContentsId(list) == typeId) {
                                list[0] = delta[0];
                            }
                        } else if (mode == Changer.ChangeMode.ADD) {
                            if (NBTUtil.getContentsId(list) == typeId) {
                                if (typeId == 10) {
                                    String newTags = (String)delta[0];
                                    Object NBT1 = null;
                                    try {
                                        NBT1 = SkStuff.this.nbtParserClass.getMethod("parse", String.class).invoke(NBT1, newTags);
                                    }
                                    catch (Exception ex) {
                                        if (ex instanceof InvocationTargetException && ex.getCause().getClass().getName().contains("MojangsonParseException")) {
                                            Skript.warning((String)("Error when parsing NBT - " + ex.getCause().getMessage()));
                                            return;
                                        }
                                        ex.printStackTrace();
                                    }
                                    NBTUtil.addToList(list[0], new Object[]{NBT1});
                                } else {
                                    NBTUtil.addToList(list[0], delta);
                                }
                            }
                        } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                            try {
                                list[0] = SkStuff.this.nbtListClass.newInstance();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            }).parser((Parser)new Parser<Object>(){

                public String getVariableNamePattern() {
                    return ".+";
                }

                @Nullable
                public Object parse(String rawNBTList, ParseContext context) {
                    return null;
                }

                public String toString(Object list, int arg1) {
                    return list.toString();
                }

                public String toVariableNameString(Object list) {
                    return list.toString();
                }
            }));
            this.effAmount += 5;
            this.exprAmount += 6;
            this.typeAmount += 2;
            if (Bukkit.getPluginManager().getPlugin("WorldEdit") != null) {
                this.getLogger().info("WorldEdit found! Registering WorldEdit stuff...");
                Skript.registerCondition(CondSelectionContains.class, (String[])new String[]{"[(world[ ]edit|we)] selection of %player% (contains|has) %location%", "%player%'s [(world[ ]edit|we)] selection (contains|has) %location%", "[(world[ ]edit|we)] selection of %player% does(n't| not) (contain|have) %location%", "%player%'s [(world[ ]edit|we)] selection does(n't| not) (contain|have) %location%"});
                Skript.registerEffect(EffDrawLineWE.class, (String[])new String[]{"(create|draw|make) [a[n]] (0\u00a6(no(n|t)(-| )hollow|filled|)|1\u00a6hollow) line from %location% to %location% (using|with) [edit[ ]session] %editsession% (using|with) [block[s]] %itemstacks% [with] thick[ness] %double%"});
                Skript.registerEffect(EffUndoRedoSession.class, (String[])new String[]{"(0\u00a6undo|1\u00a6redo) (change|edit)s (of|from) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffRememberChanges.class, (String[])new String[]{"make %player% (remember|be able to undo) changes (of|from) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffMakeSphere.class, (String[])new String[]{"(create|make) [a[n]] (0\u00a6(no(n|t)(-| )hollow|filled|)|1\u00a6hollow) (ellipsoid|sphere) [centered] at %location% [with] radius [of] %double%,[ ]%double%(,[ ]| and )%double% (using|with) [edit[ ]session] %editsession% (using|with) [block[s]] %itemstacks%"});
                Skript.registerEffect(EffSimulateSnow.class, (String[])new String[]{"(simulate snow at|place snow over) %location% (in|within) [a] radius [of] %double% (using|with) [edit[ ]session] %editsession%", "make %location% snowy (in|within) [a] radius [of] %double% (using|with) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffMakePyramid.class, (String[])new String[]{"(create|make) [a[n]] (0\u00a6(no(n|t)(-| )hollow|filled|)|1\u00a6hollow) pyramid at %location% [with] radius [of] %integer% (using|with) [edit[ ]session] %editsession% (using|with) [block[s]] %itemstacks%"});
                Skript.registerEffect(EffDrainLiquid.class, (String[])new String[]{"(drain|remove) [all] liquid[s] at %location% (in|within) [a] radius [of] %double% (using|with) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffNaturalize.class, (String[])new String[]{"naturalize ([cuboid] region|[all] blocks) (from|between) %location% (to|and) %location% (using|with) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffMakeWalls.class, (String[])new String[]{"(create|make) wall[s] from %location% to %location% (using|with) [edit[ ]session] %editsession% (using|with) [block[s]] %itemstacks%"});
                Skript.registerEffect(EffSetBlocksWE.class, (String[])new String[]{"set [all] blocks (from|between) %location% (to|and) %location% to %itemstacks% (using|with) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffMakeCylinder.class, (String[])new String[]{"(create|make) [a[n]] (0\u00a6(no(n|t)(-| )hollow|filled|)|1\u00a6hollow) cylinder at %location% [with] radius [of] %double%,[ ]%integer%(,[ ]| and )%double% (using|with) [edit[ ]session] %editsession% (using|with) [block[s]] %itemstacks%"});
                Skript.registerEffect(EffReplaceBlocksWE.class, (String[])new String[]{"replace [all] %itemstacks% (from|between) %location% (to|and) %location% with %itemstacks% (using|with) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffPasteSchematic.class, (String[])new String[]{"paste schem[atic] %string% at %location% using [edit[ ]session] %editsession% (0\u00a6|1\u00a6(ignor(e|ing)|without|[with] no) air)"});
                Skript.registerExpression(ExprEditSessionLimit.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[block] limit [change] of [edit[ ]session] %editsession%"});
                Skript.registerExpression(ExprChangedBlocksSession.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"number of [all] changed blocks (in|of) [edit[ ]session] %editsession%"});
                Skript.registerExpression(ExprNewEditSession.class, EditSession.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[new] edit[ ]session in [world] %world% [with] [max[imum]] [block] limit [change] [of] %integer%"});
                Skript.registerExpression(ExprSelectionOfPlayer.class, Location.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(world[ ]edit|we)] selection of %player%", "%player%'s [(world[ ]edit|we)] selection"});
                Skript.registerExpression(ExprSelectionPos.class, Location.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(world[ ]edit|we)] po(s|int)[ ](0\u00a61|1\u00a62) of %player%", "%player%'s [(world[ ]edit|we)] po(s|int)[ ](0\u00a61|1\u00a62)"});
                Skript.registerExpression(ExprSelectionArea.class, Integer.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"(0\u00a6volume|1\u00a6(x( |-)size|width)|2\u00a6(y( |-)size|height)|3\u00a6(z( |-)size|length)|4\u00a6area) of [(world[ ]edit|we)] selection of %player%", "%player%'s [(world[ ]edit|we)] selection (0\u00a6volume|1\u00a6(x( |-)size|width)|2\u00a6(y( |-)size|height)|3\u00a6(z( |-)size|length)|4\u00a6area)"});
                Skript.registerExpression(ExprSchematicArea.class, Integer.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"(0\u00a6volume|1\u00a6(x( |-)size|width)|2\u00a6(y( |-)size|height)|3\u00a6(z( |-)size|length)|4\u00a6area) of schem[atic] [from] %string%"});
                Classes.registerClass((ClassInfo)new ClassInfo(EditSession.class, "editsession").name("Edit Session").user(new String[]{"edit ?sessions?"}));
                try {
                    Class.forName("com.sk89q.worldedit.extent.logging.AbstractLoggingExtent");
                    new WorldEditChangeHandler();
                    Skript.registerEvent((String)"WorldEdit block change", SimpleEvent.class, EvtWorldEditChange.class, (String[])new String[]{"world[ ]edit [block] (chang(e|ing)|edit[ing])"});
                    EventValues.registerEventValue(EvtWorldEditChange.class, Player.class, (Getter)new Getter<Player, EvtWorldEditChange>(){

                        @Nullable
                        public Player get(EvtWorldEditChange e) {
                            return EvtWorldEditChange.getPlayer();
                        }
                    }, (int)0);
                    EventValues.registerEventValue(EvtWorldEditChange.class, Block.class, (Getter)new Getter<Block, EvtWorldEditChange>(){

                        @Nullable
                        public Block get(EvtWorldEditChange e) {
                            return EvtWorldEditChange.getBlock();
                        }
                    }, (int)0);
                    ++this.evtAmount;
                }
                catch (ClassNotFoundException ex) {
                    Skript.error((String)"Unable to register \"On WorldEdit block change\" event! You will need to upgrade to WorldEdit 6.0");
                    return;
                }
                ++this.condAmount;
                this.effAmount += 13;
                this.exprAmount += 7;
                ++this.typeAmount;
            }
            if (Bukkit.getPluginManager().getPlugin("VanishNoPacket") != null) {
                this.getLogger().info("VanishNoPacket was found! Registering vanishing features...");
                Skript.registerEffect(EffToggleVanish.class, (String[])new String[]{"toggle vanish (state|mode) of %player% (0\u00a6|1\u00a6(silently|quietly))", "toggle %player%'s vanish (state|mode) (0\u00a6|1\u00a6(silently|quietly))"});
                Skript.registerExpression(ExprVanishState.class, Boolean.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"vanish (state|mode) of %player%", "%player%'s vanish (state|mode)"});
                ++this.effAmount;
                ++this.exprAmount;
            }
            this.getLogger().info("Everything ready! Loaded a total of " + this.condAmount + " conditions, " + this.effAmount + " effects, " + this.evtAmount + "events, " + this.exprAmount + " expressions and " + this.typeAmount + " types!");
        } else {
            this.getLogger().info("Unable to find Skript or Skript isn't accepting registrations, disabling SkStuff...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.getLogger().info("SkStuff " + this.getDescription().getVersion() + " has been successfully disabled.");
    }
}

