/*
 * Decompiled with CFR 0.152.
 */
package me.TheBukor.SkStuff;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import ch.njol.util.coll.CollectionUtils;
import com.sk89q.worldedit.EditSession;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import me.TheBukor.SkStuff.conditions.CondSelectionContains;
import me.TheBukor.SkStuff.effects.EffDrainLiquid;
import me.TheBukor.SkStuff.effects.EffDrawLineWE;
import me.TheBukor.SkStuff.effects.EffMakeCylinder;
import me.TheBukor.SkStuff.effects.EffMakePyramid;
import me.TheBukor.SkStuff.effects.EffMakeSphere;
import me.TheBukor.SkStuff.effects.EffMakeWalls;
import me.TheBukor.SkStuff.effects.EffNaturalize;
import me.TheBukor.SkStuff.effects.EffRememberChanges;
import me.TheBukor.SkStuff.effects.EffReplaceBlocksWE;
import me.TheBukor.SkStuff.effects.EffSetBlocksWE;
import me.TheBukor.SkStuff.effects.EffSimulateSnow;
import me.TheBukor.SkStuff.effects.EffToggleVanish;
import me.TheBukor.SkStuff.effects.EffUndoRedoSession;
import me.TheBukor.SkStuff.events.EvtWorldEditChange;
import me.TheBukor.SkStuff.events.WorldEditChangeHandler;
import me.TheBukor.SkStuff.expressions.ExprChangedBlocksSession;
import me.TheBukor.SkStuff.expressions.ExprEditSessionLimit;
import me.TheBukor.SkStuff.expressions.ExprFileNBT;
import me.TheBukor.SkStuff.expressions.ExprFireProof;
import me.TheBukor.SkStuff.expressions.ExprItemNBT;
import me.TheBukor.SkStuff.expressions.ExprNBTOf;
import me.TheBukor.SkStuff.expressions.ExprNewEditSession;
import me.TheBukor.SkStuff.expressions.ExprNoClip;
import me.TheBukor.SkStuff.expressions.ExprSchematicArea;
import me.TheBukor.SkStuff.expressions.ExprSelectionArea;
import me.TheBukor.SkStuff.expressions.ExprSelectionOfPlayer;
import me.TheBukor.SkStuff.expressions.ExprSelectionPos;
import me.TheBukor.SkStuff.expressions.ExprTagOf;
import me.TheBukor.SkStuff.expressions.ExprTimespanToNumber;
import me.TheBukor.SkStuff.expressions.ExprToLowerCase;
import me.TheBukor.SkStuff.expressions.ExprToUpperCase;
import me.TheBukor.SkStuff.expressions.ExprVanishState;
import me.TheBukor.SkStuff.expressions.ExprWordsToUpperCase;
import me.TheBukor.SkStuff.util.NBTUtil;
import me.TheBukor.SkStuff.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.fusesource.jansi.Ansi;

public class SkStuff
extends JavaPlugin {
    private int condAmount = 0;
    private int effAmount = 0;
    private int evtAmount = 0;
    private int exprAmount = 0;
    private int typeAmount = 0;
    private Class<?> nbtClass = ReflectionUtils.getNMSClass("NBTTagCompound");
    private Class<?> nbtParserClass = ReflectionUtils.getNMSClass("MojangsonParser");

    public void onEnable() {
        if (Bukkit.getPluginManager().getPlugin("Skript") != null && Skript.isAcceptRegistrations()) {
            Skript.registerAddon((JavaPlugin)this);
            this.getLogger().info("SkStuff " + this.getDescription().getVersion() + " has been successfully enabled!");
            this.getLogger().info("Registering general non version specific stuff...");
            Skript.registerExpression(ExprToUpperCase.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%string% [converted] to [all] (cap[ital]s|upper[ ]case)", "convert %string% to [all] (cap[ital]s|upper[ ]case)", "capitalize [all] [char[acter]s (of|in)] %string%"});
            Skript.registerExpression(ExprToLowerCase.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%string% [converted] to [all] lower[ ]case", "convert %string% to [all] lower[ ]case", "un[( |-)]capitalize [all] [char[acter]s (of|in)] %string%"});
            Skript.registerExpression(ExprWordsToUpperCase.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"(first|1st) (letter|char[acter]) (of|in) (each word|[all] words) (of|in) %string% [converted] to (cap[ital]s|upper[ ]case) (0\u00a6|1\u00a6ignoring [other] upper[ ]case [(char[acter]s|letters)])", "convert (first|1st) (letter|char[acter]) (of|in) (each word|[all] words) (of|in) %string% to (cap[ital]s|upper[ ]case) (0\u00a6|1\u00a6ignoring [other] upper[ ]case [(char[acter]s|letters)])", "capitalize (first|1st) (letter|char[acter]) (of|in) (each word|[all] words) (of|in) %string% (0\u00a6|1\u00a6ignoring [other] upper[ ]case [(char[acter]s|letters)])"});
            Skript.registerExpression(ExprTimespanToNumber.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%timespan% [converted] [in]to (0\u00a6ticks|1\u00a6sec[ond]s|2\u00a6min[ute]s|3\u00a6hours|4\u00a6days)"});
            this.exprAmount += 4;
            this.getLogger().info("Trying to register version specific stuff...");
            Skript.registerExpression(ExprNBTOf.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"nbt[[ ]tag[s]] of %entity/block/itemstack%", "%entity/block/itemstack%'s nbt[[ ]tag[s]]"});
            Skript.registerExpression(ExprItemNBT.class, ItemStack.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%itemstack% with [custom] nbt[[ ]tag[s]] %string%"});
            Skript.registerExpression(ExprTagOf.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[nbt[ ]]tag %string% of [[nbt] compound] %compound%"});
            Skript.registerExpression(ExprFileNBT.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"nbt[[ ]tag[s]] from [file] %string%"});
            Skript.registerExpression(ExprNoClip.class, Boolean.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"no[( |-)]clip (state|mode) of %entity%", "%entity%'s no[( |-)]clip (state|mode)"});
            Skript.registerExpression(ExprFireProof.class, Boolean.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"fire[ ]proof (state|mode) of %entity%", "%entity%'s fire[ ]proof (state|mode)"});
            Classes.registerClass((ClassInfo)new ClassInfo(this.nbtClass, "compound").user(new String[]{"((nbt)?( ?tag)?) ?compounds?"}).name("NBT Compound").changer((Changer)new Changer<Object>(){

                @Nullable
                public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                    if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
                        return (Class[])CollectionUtils.array((Object[])new Class[]{String[].class});
                    }
                    return null;
                }

                public void change(Object[] NBT, @Nullable Object[] delta, Changer.ChangeMode mode) {
                    if (NBT[0].getClass().getName().contains("NBTTagCompound")) {
                        if (!(delta[0] instanceof String)) {
                            return;
                        }
                        String newTags = (String)delta[0];
                        if (mode == Changer.ChangeMode.ADD) {
                            Object NBT1 = null;
                            try {
                                NBT1 = SkStuff.this.nbtParserClass.getMethod("parse", String.class).invoke(NBT1, newTags);
                            }
                            catch (Exception ex) {
                                if (ex instanceof InvocationTargetException && ex.getCause().getClass().getName().contains("MojangsonParseException")) {
                                    SkStuff.this.getLogger().warning(Ansi.ansi().fgBright(Ansi.Color.RED) + "Error when parsing NBT - " + ex.getCause().getMessage() + Ansi.ansi().fgBright(Ansi.Color.DEFAULT));
                                    return;
                                }
                                ex.printStackTrace();
                            }
                            NBTUtil.addCompound(NBT[0], NBT1);
                        } else if (mode == Changer.ChangeMode.REMOVE) {
                            Object[] objectArray = delta;
                            int n = delta.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object s = objectArray[n2];
                                try {
                                    SkStuff.this.nbtClass.getMethod("remove", String.class).invoke(NBT[0], (String)s);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                ++n2;
                            }
                        }
                    }
                }
            }).parser((Parser)new Parser<Object>(){

                public String getVariableNamePattern() {
                    return "nbt:{.+:.+}";
                }

                @Nullable
                public Object parse(String rawNBT, ParseContext context) {
                    if (rawNBT.startsWith("{") && rawNBT.contains(":") && rawNBT.endsWith("}")) {
                        Object NBT = null;
                        try {
                            NBT = SkStuff.this.nbtParserClass.getMethod("parse", String.class).invoke(NBT, rawNBT);
                        }
                        catch (Exception ex) {
                            if (ex instanceof InvocationTargetException && ex.getCause().getClass().getName().contains("MojangsonParseException")) {
                                return null;
                            }
                            ex.printStackTrace();
                        }
                        if (NBT.toString().equals("{}") || NBT == null) {
                            return null;
                        }
                        return NBT;
                    }
                    return null;
                }

                public String toString(Object compound, int arg1) {
                    return compound.toString();
                }

                public String toVariableNameString(Object compound) {
                    return "nbt:" + compound.toString();
                }
            }));
            ++this.typeAmount;
            this.exprAmount += 6;
            if (Bukkit.getPluginManager().getPlugin("WorldEdit") != null) {
                this.getLogger().info("WorldEdit found! Registering WorldEdit stuff...");
                Skript.registerCondition(CondSelectionContains.class, (String[])new String[]{"[(world[ ]edit|we)] selection of %player% (contains|has) %location%", "%player%'s [(world[ ]edit|we)] selection (contains|has) %location%", "[(world[ ]edit|we)] selection of %player% does(n't| not) (contain|have) %location%", "%player%'s [(world[ ]edit|we)] selection does(n't| not) (contain|have) %location%"});
                Skript.registerEffect(EffDrawLineWE.class, (String[])new String[]{"(create|draw|make) [a[n]] (0\u00a6(no(n|t)(-| )hollow|filled|)|1\u00a6hollow) line from %location% to %location% (using|with) [edit[ ]session] %editsession% (using|with) [block[s]] %itemstacks% [with] thick[ness] %double%"});
                Skript.registerEffect(EffUndoRedoSession.class, (String[])new String[]{"(0\u00a6undo|1\u00a6redo) (change|edit)s (of|from) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffRememberChanges.class, (String[])new String[]{"make %player% (remember|be able to undo) changes (of|from) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffMakeSphere.class, (String[])new String[]{"(create|make) [a[n]] (0\u00a6(no(n|t)(-| )hollow|filled|)|1\u00a6hollow) (ellipsoid|sphere) [centered] at %location% [with] radius [of] %double%,[ ]%double%(,[ ]| and )%double% (using|with) [edit[ ]session] %editsession% (using|with) [block[s]] %itemstacks%"});
                Skript.registerEffect(EffSimulateSnow.class, (String[])new String[]{"(simulate snow at|place snow over) %location% (in|within) [a] radius [of] %double% (using|with) [edit[ ]session] %editsession%", "make %location% snowy (in|within) [a] radius [of] %double% (using|with) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffMakePyramid.class, (String[])new String[]{"(create|make) [a[n]] (0\u00a6(no(n|t)(-| )hollow|filled|)|1\u00a6hollow) pyramid at %location% [with] radius [of] %integer% (using|with) [edit[ ]session] %editsession% (using|with) [block[s]] %itemstacks%"});
                Skript.registerEffect(EffDrainLiquid.class, (String[])new String[]{"(drain|remove) [all] liquid[s] at %location% (in|within) [a] radius [of] %double% (using|with) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffNaturalize.class, (String[])new String[]{"naturalize ([cuboid] region|[all] blocks) (from|between) %location% (to|and) %location% (using|with) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffMakeWalls.class, (String[])new String[]{"(create|make) wall[s] from %location% to %location% (using|with) [edit[ ]session] %editsession% (using|with) [block[s]] %itemstacks%"});
                Skript.registerEffect(EffSetBlocksWE.class, (String[])new String[]{"set [all] blocks (from|between) %location% (to|and) %location% to %itemstacks% (using|with) [edit[ ]session] %editsession%"});
                Skript.registerEffect(EffMakeCylinder.class, (String[])new String[]{"(create|make) [a[n]] (0\u00a6(no(n|t)(-| )hollow|filled|)|1\u00a6hollow) cylinder at %location% [with] radius [of] %double%,[ ]%integer%(,[ ]| and )%double% (using|with) [edit[ ]session] %editsession% (using|with) [block[s]] %itemstacks%"});
                Skript.registerEffect(EffReplaceBlocksWE.class, (String[])new String[]{"replace [all] %itemstacks% (from|between) %location% (to|and) %location% with %itemstacks% (using|with) [edit[ ]session] %editsession%"});
                Skript.registerExpression(ExprEditSessionLimit.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[block] limit [change] of [edit[ ]session] %editsession%"});
                Skript.registerExpression(ExprChangedBlocksSession.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"number of [all] changed blocks (in|of) [edit[ ]session] %editsession%"});
                Skript.registerExpression(ExprNewEditSession.class, EditSession.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[new] edit[ ]session in [world] %world% [with] [max[imum]] [block] limit [change] [of] %integer%"});
                Skript.registerExpression(ExprSelectionOfPlayer.class, Location.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(world[ ]edit|we)] selection of %player%", "%player%'s [(world[ ]edit|we)] selection"});
                Skript.registerExpression(ExprSelectionPos.class, Location.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(world[ ]edit|we)] po(s|int)[ ](0\u00a61|1\u00a62) of %player%", "%player%'s [(world[ ]edit|we)] po(s|int)[ ](0\u00a61|1\u00a62)"});
                Skript.registerExpression(ExprSelectionArea.class, Integer.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"(0\u00a6volume|1\u00a6(x( |-)size|width)|2\u00a6(y( |-)size|height)|3\u00a6(z( |-)size|length)|4\u00a6area) of [(world[ ]edit|we)] selection of %player%", "%player%'s [(world[ ]edit|we)] selection (0\u00a6volume|1\u00a6(x( |-)size|width)|2\u00a6(y( |-)size|height)|3\u00a6(z( |-)size|length)|4\u00a6area)"});
                Skript.registerExpression(ExprSchematicArea.class, Integer.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"(0\u00a6volume|1\u00a6(x( |-)size|width)|2\u00a6(y( |-)size|height)|3\u00a6(z( |-)size|length)|4\u00a6area) of schem[atic] [from] %string%"});
                Classes.registerClass((ClassInfo)new ClassInfo(EditSession.class, "editsession").name("Edit Session").user(new String[]{"edit ?sessions?"}));
                try {
                    Class.forName("com.sk89q.worldedit.extent.logging.AbstractLoggingExtent");
                    new WorldEditChangeHandler();
                    Skript.registerEvent((String)"WorldEdit block change", SimpleEvent.class, EvtWorldEditChange.class, (String[])new String[]{"world[ ]edit [block] (chang(e|ing)|edit[ing])"});
                    EventValues.registerEventValue(EvtWorldEditChange.class, Player.class, (Getter)new Getter<Player, EvtWorldEditChange>(){

                        @Nullable
                        public Player get(EvtWorldEditChange e) {
                            return EvtWorldEditChange.getPlayer();
                        }
                    }, (int)0);
                    EventValues.registerEventValue(EvtWorldEditChange.class, Block.class, (Getter)new Getter<Block, EvtWorldEditChange>(){

                        @Nullable
                        public Block get(EvtWorldEditChange e) {
                            return EvtWorldEditChange.getBlock();
                        }
                    }, (int)0);
                    ++this.evtAmount;
                }
                catch (ClassNotFoundException ex) {
                    Skript.error((String)"Unable to register \"On WorldEdit block change\" event! You will need to upgrade to WorldEdit 6.0");
                    return;
                }
                ++this.condAmount;
                this.effAmount += 12;
                this.exprAmount += 7;
                ++this.typeAmount;
            }
            if (Bukkit.getPluginManager().getPlugin("VanishNoPacket") != null) {
                this.getLogger().info("VanishNoPacket was found! Registering vanishing features...");
                Skript.registerEffect(EffToggleVanish.class, (String[])new String[]{"toggle vanish (state|mode) of %player% (0\u00a6|1\u00a6(silently|quietly))", "toggle %player%'s vanish (state|mode) (0\u00a6|1\u00a6(silently|quietly))"});
                Skript.registerExpression(ExprVanishState.class, Boolean.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"vanish (state|mode) of %player%", "%player%'s vanish (state|mode)"});
                ++this.effAmount;
                ++this.exprAmount;
            }
            this.getLogger().info("Everything ready! Loaded a total of " + this.condAmount + " conditions, " + this.effAmount + " effects, " + this.evtAmount + "events, " + this.exprAmount + " expressions and " + this.typeAmount + " types!");
        } else {
            this.getLogger().info("Unable to find Skript or Skript isn't accepting registrations, disabling SkStuff...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.getLogger().info("SkStuff " + this.getDescription().getVersion() + " has been successfully disabled.");
    }
}

