/*
 * Decompiled with CFR 0.152.
 */
package space.gatt.skswm.elements.exprs;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.grinderwolf.swm.api.loaders.SlimeLoader;
import java.io.IOException;
import org.bukkit.event.Event;
import space.gatt.skswm.SWMAddon;
import space.gatt.skswm.enums.SWMStorageType;

@Name(value="SlimeWorldManager - All SlimeWorlds")
@Description(value={"List all SlimeWorlds."})
@Examples(value={"set {gameworld::worlds::*} to all slime worlds in file"})
@Since(value="1.0.0")
public class ExprSlimeWorlds
extends SimpleExpression<String> {
    private Expression<SWMStorageType> storageType;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parse) {
        this.storageType = expressions[0];
        return true;
    }

    protected String[] get(Event event) {
        String loaderType = ((SWMStorageType)((Object)this.storageType.getSingle(event))).name().toLowerCase();
        SlimeLoader loader = SWMAddon.getInstance().getSlimeInstance().getLoader(loaderType);
        try {
            return loader.listWorlds().toArray(new String[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean b) {
        return "slime world property map";
    }

    static {
        Skript.registerExpression(ExprSlimeWorlds.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"all slime worlds in %swmstoragetype%"});
    }
}

