/*
 * Decompiled with CFR 0.152.
 */
package space.gatt.skswm.elements.exprs;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import org.bukkit.event.Event;
import space.gatt.skswm.enums.SWMProperty;

@Name(value="SlimeWorldManager - New SlimePropertyMap Instance")
@Description(value={"Create a new SlimePropertyMap."})
@Examples(value={"set {_spm} to new slime world property map"})
@Since(value="1.0.0")
public class ExprNewSlimePropertyMap
extends SimpleExpression<SlimePropertyMap> {
    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parse) {
        return true;
    }

    protected SlimePropertyMap[] get(Event event) {
        SlimePropertyMap map = new SlimePropertyMap();
        block10: for (SWMProperty prop : SWMProperty.values()) {
            switch (prop.getValueType()) {
                case "String": {
                    map.setString(prop.getProperty(), (String)prop.getProperty().getDefaultValue());
                    continue block10;
                }
                case "Boolean": {
                    map.setBoolean(prop.getProperty(), ((Boolean)prop.getProperty().getDefaultValue()).booleanValue());
                    continue block10;
                }
                case "Integer": {
                    map.setInt(prop.getProperty(), ((Integer)prop.getProperty().getDefaultValue()).intValue());
                }
            }
        }
        return new SlimePropertyMap[]{map};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends SlimePropertyMap> getReturnType() {
        return SlimePropertyMap.class;
    }

    public String toString(Event event, boolean b) {
        return "slime world property map";
    }

    static {
        Skript.registerExpression(ExprNewSlimePropertyMap.class, SlimePropertyMap.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"new slime world property map"});
    }
}

