/*
 * Decompiled with CFR 0.152.
 */
package space.gatt.skswm.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.grinderwolf.swm.api.exceptions.UnknownWorldException;
import java.io.IOException;
import org.bukkit.event.Event;
import space.gatt.skswm.SWMAddon;
import space.gatt.skswm.enums.SWMStorageType;

@Name(value="SlimeWorldManager - Delete Slime World")
@Description(value={"Delete Slime World. Cannot be undone"})
@Examples(value={"delete slime world \"coolworld\" in mongodb"})
@Since(value="1.0.0")
public class EffDeleteSlimeWorld
extends Effect {
    private Expression<String> worldName;
    private Expression<SWMStorageType> storageType;

    protected void execute(Event event) {
        String worldName = (String)this.worldName.getSingle(event);
        SWMStorageType type = (SWMStorageType)((Object)this.storageType.getSingle(event));
        try {
            SWMAddon.getInstance().getSlimeInstance().getLoader(type.name().toLowerCase()).deleteWorld(worldName);
        }
        catch (UnknownWorldException | IOException e) {
            e.printStackTrace();
        }
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.worldName = expressions[0];
        this.storageType = expressions[1];
        return true;
    }

    public String toString(Event event, boolean b) {
        return "delete world";
    }

    static {
        Skript.registerEffect(EffDeleteSlimeWorld.class, (String[])new String[]{"delete [slime ]world %string% from %swmstoragetype%"});
    }
}

