/*
 * Decompiled with CFR 0.152.
 */
package space.gatt.skswm.elements.exprs;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import org.bukkit.event.Event;
import space.gatt.skswm.enums.SWMProperty;

@Name(value="SlimeWorldManager - Change Property Value")
@Description(value={"Modifies a property value."})
@Examples(value={"set spawn x of {_props} to 6"})
@Since(value="1.0.0")
public class ExprSlimePropertyValue
extends SimpleExpression<Object> {
    private Expression<SlimePropertyMap> properties;
    private Expression<SWMProperty> propertyType;

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.SET) {
            Skript.error((String)("Cannot " + mode.toString() + " a property type."));
            return null;
        }
        return (Class[])CollectionUtils.array((Object[])new Class[]{this.isSingle() ? Object.class : Object[].class});
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.propertyType = expressions[0];
        this.properties = expressions[1];
        return true;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.SET) {
            return;
        }
        SlimePropertyMap props = (SlimePropertyMap)this.properties.getSingle(e);
        SWMProperty property = (SWMProperty)((Object)this.propertyType.getSingle(e));
        Object value = delta[0];
        switch (property.getValueType()) {
            case "String": {
                props.setString(property.getProperty(), value.toString());
                break;
            }
            case "Integer": {
                if (value instanceof Integer) {
                    props.setInt(property.getProperty(), ((Integer)value).intValue());
                    break;
                }
                Skript.error((String)(property.getProperty().getNbtName() + " expected a Integer, but got " + value.toString()));
                break;
            }
            case "Boolean": {
                if (value instanceof Boolean) {
                    props.setBoolean(property.getProperty(), ((Boolean)value).booleanValue());
                    break;
                }
                Skript.error((String)(property.getProperty().getNbtName() + " expected a Boolean, but got " + value.toString()));
            }
        }
    }

    protected Object[] get(Event event) {
        SlimePropertyMap props = (SlimePropertyMap)this.properties.getSingle(event);
        SWMProperty property = (SWMProperty)((Object)this.propertyType.getSingle(event));
        switch (property.getValueType()) {
            case "String": {
                return new String[]{props.getString(property.getProperty())};
            }
            case "Integer": {
                return new Integer[]{props.getInt(property.getProperty())};
            }
            case "Boolean": {
                return new Boolean[]{props.getBoolean(property.getProperty())};
            }
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public String toString(Event event, boolean b) {
        return "slime property";
    }

    static {
        Skript.registerExpression(ExprSlimePropertyValue.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%swmproperty% of %slimepropertymap%"});
    }
}

