/*
 * Decompiled with CFR 0.152.
 */
package space.gatt.skswm.elements.exprs;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.grinderwolf.swm.api.exceptions.WorldAlreadyExistsException;
import com.grinderwolf.swm.api.loaders.SlimeLoader;
import com.grinderwolf.swm.api.world.SlimeWorld;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import java.io.IOException;
import org.bukkit.event.Event;
import space.gatt.skswm.SWMAddon;
import space.gatt.skswm.enums.SWMStorageType;

@Name(value="SlimeWorldManager - Clone World Instance")
@Description(value={"Clone a SlimeWorld Instance."})
@Examples(value={"set {gameworld::skymapClone} to slime world cloned from {_anotherSlimeWorld} named \"SkyClone\" saved to file", "set {gameworld::skymapClone} to read-only slime world cloned from {_anotherSlimeWorld} named \"SkyClone\"  saved to file"})
@Since(value="1.1.0")
public class ExprClonedSlimeWorld
extends SimpleExpression<SlimeWorld> {
    private boolean readOnly = false;
    private Expression<SlimeWorld> worldToCopy;
    private Expression<String> newWorldName;
    private Expression<SWMStorageType> storageType;
    private Expression<SlimePropertyMap> properties = null;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parse) {
        this.worldToCopy = expressions[0];
        this.newWorldName = expressions[1];
        this.storageType = expressions[2];
        if (expressions.length == 4) {
            this.properties = expressions[3];
        }
        this.readOnly = pattern == 1;
        return true;
    }

    protected SlimeWorld[] get(Event event) {
        SlimeWorld sl;
        String loaderType = ((SWMStorageType)((Object)this.storageType.getSingle(event))).name().toLowerCase();
        SlimeLoader loader = SWMAddon.getInstance().getSlimeInstance().getLoader(loaderType);
        SlimeWorld copyFrom = (SlimeWorld)this.worldToCopy.getSingle(event);
        String worldName = (String)this.newWorldName.getSingle(event);
        SlimePropertyMap props = null;
        if (this.properties != null) {
            props = (SlimePropertyMap)this.properties.getSingle(event);
        }
        try {
            sl = copyFrom.clone(worldName, loader, this.readOnly);
        }
        catch (WorldAlreadyExistsException | IOException e) {
            e.printStackTrace();
            if (e instanceof WorldAlreadyExistsException) {
                Skript.error((String)("A World named " + worldName + " in Storage " + loaderType + " already exists."));
            }
            return null;
        }
        if (props != null) {
            sl.getPropertyMap().merge(props);
        }
        return new SlimeWorld[]{sl};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends SlimeWorld> getReturnType() {
        return SlimeWorld.class;
    }

    public String toString(Event event, boolean b) {
        return "cloned slime world";
    }

    static {
        Skript.registerExpression(ExprClonedSlimeWorld.class, SlimeWorld.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"(slime world|slimeworld|slime-world) cloned from %slimeworld% named %string% saved to %swmstoragetype%[ using properties %slimepropertymap%]", "(read-only|readonly|read only) (slime world|slimeworld|slime-world) cloned from %slimeworld% named %string% saved to %swmstoragetype%[ using properties %slimepropertymap%]"});
    }
}

