/*
 * Decompiled with CFR 0.152.
 */
package space.gatt.skswm.elements.exprs;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.grinderwolf.swm.api.loaders.SlimeLoader;
import com.grinderwolf.swm.api.world.SlimeWorld;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import org.bukkit.event.Event;
import space.gatt.skswm.SWMAddon;
import space.gatt.skswm.enums.SWMStorageType;

@Name(value="SlimeWorldManager - Load World Instance")
@Description(value={"Load a SlimeWorld Instance."})
@Examples(value={"set {gameworld::skymap} to new empty slime world named \"skymap\" from file", "set {gameworld::skymap} to new empty read-only slime world named \"skymap\" from file"})
@Since(value="1.0.0")
public class ExprEmptySlimeWorldInstance
extends SimpleExpression<SlimeWorld> {
    private boolean readOnly = false;
    private Expression<String> worldName;
    private Expression<SWMStorageType> storageType;
    private Expression<SlimePropertyMap> properties;

    public boolean init(Expression<?>[] expressions, int pattern, Kleenean kleenean, SkriptParser.ParseResult parse) {
        this.worldName = expressions[0];
        this.storageType = expressions[1];
        this.properties = expressions[2];
        this.readOnly = pattern == 1;
        return true;
    }

    protected SlimeWorld[] get(Event event) {
        SlimeWorld sl;
        String loaderType = ((SWMStorageType)((Object)this.storageType.getSingle(event))).name().toLowerCase();
        SlimeLoader loader = SWMAddon.getInstance().getSlimeInstance().getLoader(loaderType);
        String worldName = (String)this.worldName.getSingle(event);
        SlimePropertyMap props = (SlimePropertyMap)this.properties.getSingle(event);
        try {
            sl = SWMAddon.getInstance().getSlimeInstance().createEmptyWorld(loader, worldName, this.readOnly, props);
        }
        catch (Exception e) {
            SWMAddon.log(event.getEventName() + " attempted to load a SlimeWorld that threw an error. Probably an invalid name?");
            e.printStackTrace();
            return null;
        }
        return new SlimeWorld[]{sl};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends SlimeWorld> getReturnType() {
        return SlimeWorld.class;
    }

    public String toString(Event event, boolean b) {
        return "slime world";
    }

    static {
        Skript.registerExpression(ExprEmptySlimeWorldInstance.class, SlimeWorld.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[new ]empty (slime world|slimeworld|slime-world) named %string% from %swmstoragetype% using properties %slimepropertymap%", "[new ](read-only|readonly|read only) (slime world|slimeworld|slime-world) named %string% from %swmstoragetype% using properties %slimepropertymap%"});
    }
}

