/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.headshot.expressions.worldguard;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.headshot.SKRambled;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.craftbukkit.libs.jline.internal.Nullable;
import org.bukkit.event.Event;

public class ExprOwnersOfRegion
extends SimpleExpression<OfflinePlayer> {
    private Expression<ProtectedRegion> region;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.region = exprs[0];
        return true;
    }

    protected OfflinePlayer[] get(Event e) {
        ProtectedRegion region = (ProtectedRegion)this.region.getSingle(e);
        Set names = region.getOwners().getPlayers();
        ArrayList<OfflinePlayer> r = new ArrayList<OfflinePlayer>(names.size());
        for (String name : names) {
            r.add(Bukkit.getOfflinePlayer((String)name));
        }
        return r.toArray(new OfflinePlayer[r.size()]);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "owner list";
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        OfflinePlayer player;
        ProtectedRegion region = (ProtectedRegion)this.region.getSingle(e);
        if (region == null) {
            return;
        }
        if (mode == Changer.ChangeMode.ADD) {
            player = (OfflinePlayer)delta[0];
            region.getOwners().addPlayer(player.getName());
        }
        if (mode == Changer.ChangeMode.REMOVE) {
            player = (OfflinePlayer)delta[0];
            region.getOwners().removePlayer(player.getName());
        }
        if (mode == Changer.ChangeMode.RESET) {
            region.getOwners().removeAll();
        }
        for (World w : SKRambled.getInstance().getServer().getWorlds()) {
            try {
                SKRambled.getWorldGuard().getRegionManager(w).save();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class});
    }
}

