/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;

public class Collect {
    public static String[] toStringArray(Object[] array) {
        String[] strings = new String[array.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = array[i].toString();
        }
        return strings;
    }

    public static String[] toFriendlyStringArray(Object[] array) {
        String[] strings = new String[array.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = array[i].toString().toLowerCase().replace("_", " ");
        }
        return strings;
    }

    @SafeVarargs
    public static <T> T[] asArray(T ... objects) {
        return objects;
    }

    public static <T> T[] newArray(Class<?> type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    public static String[] asSkriptProperty(String property, String fromType) {
        return Collect.asArray("[the] " + property + " of %" + fromType + "%", "%" + fromType + "%'[s] " + property);
    }

    public static <T> String toString(T[] array) {
        return Collect.toString(array, ',');
    }

    public static <T> String toString(T[] array, char separator) {
        return Collect.toString(array, separator, true);
    }

    public static <T> String toString(T[] array, char separator, boolean spaces) {
        String SEPARATOR;
        String string = SEPARATOR = spaces ? " " : "";
        if (array == null) {
            return "null";
        }
        int max = array.length - 1;
        if (max == -1) {
            return "";
        }
        String b = "";
        int i = 0;
        while (true) {
            b = b + String.valueOf(array[i]);
            if (i == max) {
                return b;
            }
            b = b + separator + SEPARATOR;
            ++i;
        }
    }

    public static String getPaths(Collection<String> list) {
        StringBuilder builder = new StringBuilder();
        for (String s : list) {
            builder.append(s).append(".");
        }
        return builder.toString().substring(0, builder.length() - 1);
    }

    public static String textPart(InputStream is) {
        if (is == null) {
            return "";
        }
        try (Scanner s = new Scanner(is).useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    private static ArrayList<File> getListFiles(File root, FilenameFilter filter, ArrayList<File> toAdd) {
        for (File f : root.listFiles()) {
            if (f.isDirectory()) {
                toAdd.addAll(Collect.getListFiles(f, filter, toAdd));
                continue;
            }
            if (!filter.accept(f, f.getName())) continue;
            toAdd.add(f);
        }
        return toAdd;
    }

    public static File[] getFiles(File root, FilenameFilter filter) {
        ArrayList<File> files = Collect.getListFiles(root, filter, new ArrayList<File>());
        return files.toArray(new File[files.size()]);
    }

    public static File[] getFiles(File root) {
        return Collect.getFiles(root, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        });
    }
}

