/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.PropertyFrom;
import com.w00tmast3r.skquery.api.PropertyTo;
import com.w00tmast3r.skquery.api.UsePropertyPatterns;
import com.w00tmast3r.skquery.util.Collect;
import com.w00tmast3r.skquery.util.menus.FormattedSlotManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.eclipse.jdt.annotation.Nullable;

@UsePropertyPatterns
@PropertyFrom(value="inventories")
@PropertyTo(value="inventory (title|name)[s]")
public class ExprInventoryNameContainer
extends PropertyExpression<Inventory, String> {
    private static final boolean older = Skript.methodExists(Inventory.class, (String)"getTitle", (Class[])new Class[0]);
    private Method method;

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (older) {
            try {
                this.method = Inventory.class.getMethod("getTitle", new Class[0]);
                this.method.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
                Skript.error((String)("There was an error attempting to grab the inventory name. " + Skript.getMinecraftVersion().toString()));
                return false;
            }
        }
        this.setExpr(exprs[0]);
        return true;
    }

    protected String[] get(final Event event, Inventory[] source) {
        return (String[])this.get(source, (Converter)new Converter<Inventory, String>(){

            public String convert(Inventory inventory) {
                if (older) {
                    try {
                        return (String)ExprInventoryNameContainer.this.method.invoke((Object)inventory, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        return null;
                    }
                }
                InventoryHolder holder = inventory.getHolder();
                if (holder == null || !(holder instanceof Container)) {
                    InventoryClickEvent inventoryEvent;
                    if (event instanceof InventoryClickEvent && (inventoryEvent = (InventoryClickEvent)event).getClickedInventory() == inventory) {
                        return inventoryEvent.getView().getTitle();
                    }
                    Skript.error((String)"In 1.13+ you cannot get the title name of an inventory outside of an InventoryClickEvent, Only if this inventory has an InventoryHolder may it be used in this state.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    return null;
                }
                return ((Container)holder).getCustomName();
            }
        });
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "inventory names of " + this.getExpr().toString(event, debug);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return Collect.asArray(String.class);
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String title = delta[0] == null ? "" : (String)delta[0];
        for (Inventory inventory : (Inventory[])this.getExpr().getArray(event)) {
            if (inventory.getType() != InventoryType.CHEST) continue;
            Inventory copy = Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (int)inventory.getSize(), (String)title);
            inventory.getViewers().parallelStream().map(human -> (Player)human).forEach(player -> {
                FormattedSlotManager.exemptNextClose(player);
                player.openInventory(copy);
            });
            copy.setContents(inventory.getContents());
        }
    }
}

