/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.SkQuery;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Name(value="Trail Projectile")
@Description(value="Trails the projectile in a ProjectileLaunchEvent.")
@Patterns(value={"trail projectile with %particles%"})
public class EffTrail
extends Effect {
    private Expression<Particle> particles;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(ProjectileLaunchEvent.class)) {
            Skript.error((String)"Trailing can only be used in a shoot event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.particles = expressions[0];
        return true;
    }

    protected void execute(Event event) {
        final Particle[] particles = (Particle[])this.particles.getArray(event);
        if (particles == null || particles.length <= 0) {
            return;
        }
        final Projectile projectile = ((ProjectileLaunchEvent)event).getEntity();
        new BukkitRunnable(){

            public void run() {
                World world = projectile.getWorld();
                for (Particle particle : particles) {
                    if (particle.getDataType() != null) {
                        this.cancel();
                        return;
                    }
                    world.spawnParticle(particle, projectile.getLocation(), 0, 0.0, 0.0, 0.0);
                }
                if (!projectile.isValid() || projectile.isOnGround()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkQuery.getInstance(), 0L, 1L);
    }

    public String toString(Event event, boolean debug) {
        ProjectileLaunchEvent launch = (ProjectileLaunchEvent)event;
        return "trail " + launch.getEntity().getType() + " with visual effect " + this.particles.toString(event, debug);
    }
}

