/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.note.MidiUtil;
import org.bukkit.event.Event;

@Name(value="Stop MIDI")
@Description(value="Stops a midi file that is playing.")
@Examples(value={"on join:", "\tplay midi \"login\" to player", "\twait 5 seconds", "\tstop midi \"login\""})
@Patterns(value={"stop midi[s] [[with] id] %strings%"})
public class EffMIDIStop
extends Effect {
    private Expression<String> IDs;

    public boolean init(Expression<?>[] expressions, int markedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.IDs = expressions[0];
        return true;
    }

    protected void execute(Event event) {
        for (String track : (String[])this.IDs.getArray(event)) {
            if (track == null || !MidiUtil.isPlaying(track)) continue;
            MidiUtil.stop(track);
        }
    }

    public String toString(Event event, boolean debug) {
        return "stop midi " + this.IDs.toString(event, debug);
    }
}

