/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.note.MidiUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Play MIDI")
@Description(value="Plays a file with the extention .mid to a player.")
@Examples(value={"on join:;->play midi \"login\" to player"})
@Patterns(value={"play midi [from] %string% (for|to) %players% [at [tempo] %-number%] [with id %-string%]", "play midi from (website|link) %string% (for|to) %players% [at [tempo] %-number%] [with id %-string%]"})
public class EffMIDI
extends Effect {
    private Expression<String> midi;
    private Expression<String> ID;
    private Expression<Player> players;
    private Expression<Number> tempo;
    private boolean url;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.midi = expressions[0];
        this.players = expressions[1];
        this.tempo = expressions[2];
        this.ID = expressions[3];
        this.url = matchedPattern == 1;
        return true;
    }

    protected void execute(Event event) {
        Player[] players;
        String track = (String)this.midi.getSingle(event);
        if (track == null) {
            return;
        }
        File file = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + track + ".mid");
        if (!(file.exists() || (file = new File(track)).exists() || file.getName().endsWith(".mid"))) {
            Bukkit.getLogger().warning("Could not find midi file " + track + ".mid");
            return;
        }
        Number tempo = 1;
        if (this.tempo != null) {
            tempo = (Number)this.tempo.getSingle(event);
        }
        if ((players = (Player[])this.players.getArray(event)) == null) {
            return;
        }
        String ID = track;
        if (this.ID != null) {
            ID = (String)this.ID.getSingle(event);
        }
        try {
            if (this.url) {
                URL url = new URL(track);
                MidiUtil.playMidi(url.openStream(), tempo.floatValue(), ID, players);
            } else {
                MidiUtil.playMidi(file, tempo.floatValue(), ID, players);
            }
        }
        catch (IOException | InvalidMidiDataException e) {
            Skript.exception((Throwable)e, (String[])new String[]{"Could not play midi file " + track});
        }
    }

    public String toString(Event event, boolean debug) {
        return "play midi " + this.midi.toString(event, debug) + " to " + this.players.toString(event, debug);
    }
}

