/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.event.Event;

@Name(value="Is Prime")
@Description(value="Checks whether or not a number is prime.")
@Patterns(value={"%numbers% (is|are) [a] prime [number]", "%numbers% (isn't|is not|aren't|are not) [a] prime [number]"})
public class CondIsPrime
extends Condition {
    private Expression<Number> numbers;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.numbers = expressions[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.numbers.check(event, number -> CondIsPrime.isPrime(number.intValue()), this.isNegated());
    }

    public String toString(Event event, boolean debug) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (Event)event, (boolean)debug, this.numbers, (String)"prime");
    }

    public static boolean isPrime(int number) {
        if (number == 1) {
            return false;
        }
        if (number % 2 == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= number) {
            if (number % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }
}

