/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util.note;

import com.w00tmast3r.skquery.util.note.Instrument;
import com.w00tmast3r.skquery.util.note.MidiUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class NoteBlockReceiver
implements Receiver {
    private final Map<Integer, Integer> patches = new HashMap<Integer, Integer>();
    private final float VOLUME_RANGE = 10.0f;
    private final Player[] listeners;
    private final String ID;

    public NoteBlockReceiver(String ID, Player ... listeners) {
        this.listeners = listeners;
        this.ID = ID;
    }

    @Override
    public void send(MidiMessage midi, long time) {
        if (midi instanceof ShortMessage) {
            ShortMessage message = (ShortMessage)midi;
            int channel = message.getChannel();
            switch (message.getCommand()) {
                case 192: {
                    int patch = message.getData1();
                    this.patches.put(channel, patch);
                    break;
                }
                case 144: {
                    float volume = 10.0f * ((float)message.getData2() / 127.0f);
                    float pitch = this.getNote(this.toMCNote(message.getData1()));
                    Sound instrument = Instrument.PIANO.getSound();
                    Optional<Integer> optional = Optional.ofNullable(this.patches.get(message.getChannel()));
                    if (optional.isPresent()) {
                        instrument = channel == 9 ? MidiUtil.patchToInstrument(optional.get()) : MidiUtil.patchToInstrument(optional.get());
                    }
                    for (Player player : this.listeners) {
                        player.playSound(player.getLocation(), instrument, volume, pitch);
                    }
                    break;
                }
            }
        }
    }

    public float getNote(byte note) {
        return (float)Math.pow(2.0, (double)(note - 12) / 12.0);
    }

    private byte toMCNote(int n) {
        if (n < 54) {
            return (byte)((n - 6) % 12);
        }
        if (n > 78) {
            return (byte)((n - 6) % 12 + 12);
        }
        return (byte)(n - 54);
    }

    @Override
    public void close() {
        MidiUtil.stop(this.ID);
        this.patches.clear();
    }
}

