/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util.menus;

import com.w00tmast3r.skquery.SkQuery;
import com.w00tmast3r.skquery.util.BiValue;
import com.w00tmast3r.skquery.util.menus.SlotRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class FormattedSlotManager
implements Listener {
    private static final Map<UUID, BiValue<HashMap<Integer, SlotRule>, Event>> playerRules = new HashMap<UUID, BiValue<HashMap<Integer, SlotRule>, Event>>();
    private static final Set<UUID> exempt = new HashSet<UUID>();

    public static Map<Integer, SlotRule> getRules(Player player) {
        UUID uuid = player.getUniqueId();
        return playerRules.containsKey(uuid) ? (Map)playerRules.get(uuid).getFirst() : new HashMap<Integer, SlotRule>();
    }

    public static void setRules(Event event, Player player, HashMap<Integer, SlotRule> slotRules) {
        playerRules.put(player.getUniqueId(), new BiValue<HashMap<Integer, SlotRule>, Event>(slotRules, event));
    }

    public static void exemptNextClose(Player player) {
        exempt.add(player.getUniqueId());
    }

    public static void addRule(Event e, Player player, int slot, SlotRule rule) {
        UUID uuid = player.getUniqueId();
        if (!playerRules.containsKey(uuid)) {
            playerRules.put(uuid, new BiValue(new HashMap(), null));
        }
        playerRules.get(uuid).getFirst().put(slot, rule);
        playerRules.get(uuid).setSecond(e);
    }

    public static void removeRule(Player player, int slot) {
        UUID uuid = player.getUniqueId();
        if (!playerRules.containsKey(uuid)) {
            playerRules.put(uuid, new BiValue(new HashMap(), null));
        }
        playerRules.get(uuid).getFirst().remove(slot);
    }

    @EventHandler
    public void onDisconnect(PlayerQuitEvent event) {
        playerRules.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        final Player player = (Player)event.getWhoClicked();
        Map<Integer, SlotRule> map = FormattedSlotManager.getRules(player);
        if (event.isShiftClick() && map != null && map.size() > 0) {
            event.setCancelled(true);
        }
        assert (map != null);
        UUID uuid = player.getUniqueId();
        if (playerRules.containsKey(uuid) && event.getSlotType() == InventoryType.SlotType.CONTAINER && map.get(event.getSlot()) != null) {
            event.setCancelled(true);
            SlotRule rule = playerRules.get(uuid).getFirst().get(event.getSlot());
            rule.run(playerRules.get(uuid).getSecond());
            if (rule.willClose()) {
                Bukkit.getScheduler().runTaskLater((Plugin)SkQuery.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        player.getOpenInventory().close();
                    }
                }, 1L);
            }
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        final UUID uuid = event.getPlayer().getUniqueId();
        if (exempt.contains(uuid)) {
            exempt.remove(uuid);
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)SkQuery.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (playerRules.containsKey(uuid)) {
                    if (playerRules.get(uuid) != null) {
                        ((HashMap)((BiValue)playerRules.get(uuid)).getFirst()).clear();
                    }
                    ((BiValue)playerRules.get(uuid)).setSecond(null);
                }
            }
        }, 1L);
    }
}

