/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.EmptyIterator;
import ch.njol.util.coll.iterator.IteratorIterable;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.region.CuboidIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Patterns(value={"blocks within %chunk%"})
public class ExprBlockChunk
extends SimpleExpression<Block> {
    private Expression<Chunk> chunk;

    protected Block[] get(Event event) {
        Chunk c = (Chunk)this.chunk.getSingle(event);
        if (c == null) {
            return null;
        }
        ArrayList<Block> list = new ArrayList<Block>();
        for (Block b : new IteratorIterable(this.iterator(event))) {
            list.add(b);
        }
        return list.toArray(new Block[list.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    public String toString(Event event, boolean b) {
        return "cuboid, chunk";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.chunk = expressions[0];
        return true;
    }

    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("block");
    }

    public Iterator<Block> iterator(Event e) {
        Chunk c = (Chunk)this.chunk.getSingle(e);
        if (c == null) {
            return new EmptyIterator();
        }
        return new CuboidIterator(c);
    }
}

