/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

@Name(value="Make Damage")
@Description(value="Cause entities to damage each other. If you cause hostile mobs to attack or be attacked, they will become aggroed on the last entity that they hit or got hit by.")
@Examples(value={"command /massacre:;->trigger:;->->make all pigs damage all cows by 1"})
@Patterns(value={"(make|force) %livingentities% [to] damage %livingentities% by %number%"})
public class EffMakeDamage
extends Effect {
    private Expression<LivingEntity> attackers;
    private Expression<LivingEntity> victims;
    private Expression<Number> number;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.attackers = expressions[0];
        this.victims = expressions[1];
        this.number = expressions[2];
        return true;
    }

    protected void execute(Event event) {
        Number damage = (Number)this.number.getSingle(event);
        if (damage == null) {
            return;
        }
        for (LivingEntity victim : (LivingEntity[])this.victims.getArray(event)) {
            for (LivingEntity attacker : (LivingEntity[])this.attackers.getArray(event)) {
                victim.damage(damage.doubleValue(), (Entity)attacker);
                if (!(attacker instanceof Creature)) continue;
                ((Creature)attacker).setTarget(victim);
            }
        }
    }

    public String toString(Event event, boolean debug) {
        return "force damage on " + this.victims.toString(event, debug) + " from " + this.attackers.toString(event, debug);
    }
}

