/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Entity Homing")
@Description(value="Cause an entity to home towards a locations. Specifying 'normally' reduces bugs caused by varying distances, but makes it less accurate.")
@Examples(value={"make targeted entity home towards player normally"})
@Patterns(value={"make %entity% home towards %location%", "make %entities% home towards %location% normally"})
public class EffHoming
extends Effect {
    private Expression<Entity> entities;
    private Expression<Location> location;
    private boolean isNormal;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = expressions[0];
        this.location = expressions[1];
        this.isNormal = matchedPattern == 1;
        return true;
    }

    protected void execute(Event event) {
        Location loc = (Location)this.location.getSingle(event);
        if (loc == null) {
            return;
        }
        for (Entity entity : (Entity[])this.entities.getArray(event)) {
            Vector vector = loc.toVector().subtract(entity.getLocation().toVector());
            entity.setVelocity(this.isNormal ? vector.normalize() : vector);
        }
    }

    public String toString(Event event, boolean debug) {
        return "home from " + this.entities.toString(event, debug) + " to " + this.location.toString(event, debug);
    }
}

