/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.event.Event;

@Name(value="Is Divisible")
@Description(value="Checks whether or not a number can be divided into another number.")
@Patterns(value={"%numbers% (is|are) divisible by %number%", "%number% (isn't|is not|aren't|are not) divisible by %number%"})
public class CondIsDivisible
extends Condition {
    private Expression<Number> numbers;
    private Expression<Number> divisible;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.numbers = expressions[0];
        this.divisible = expressions[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        float div = ((Number)this.divisible.getSingle(event)).floatValue();
        return this.numbers.check(event, number -> number.floatValue() % div == 0.0f, this.isNegated());
    }

    public String toString(Event event, boolean debug) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (Event)event, (boolean)debug, this.numbers, (String)("divisible by " + this.divisible.toString(event, debug)));
    }
}

