/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.event.Event;

@Name(value="Is Block")
@Description(value="Checks whether or not a certain itemtype is a placeable block.")
@Patterns(value={"%itemtype% is [a] block", "%itemtype% (isn't|is not) [a] block"})
public class CondIsBlock
extends Condition {
    private Expression<ItemType> itemtype;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemtype = expressions[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.isNegated() ? !((ItemType)this.itemtype.getSingle(event)).hasBlock() : ((ItemType)this.itemtype.getSingle(event)).hasBlock();
    }

    public String toString(Event event, boolean debug) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (Event)event, (boolean)debug, this.itemtype, (String)"block");
    }
}

