/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util.note;

import ch.njol.skript.Skript;
import com.w00tmast3r.skquery.util.note.Instrument;
import com.w00tmast3r.skquery.util.note.NoteBlockReceiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class MidiUtil {
    private static HashMap<String, Sequencer> playing = new HashMap();
    private static final int[] instruments = new int[]{0, 0, 0, 0, 0, 0, 0, 5, 9, 9, 9, 9, 9, 6, 0, 9, 9, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 9, 8, 5, 8, 6, 6, 3, 3, 2, 2, 2, 6, 5, 1, 1, 1, 6, 1, 2, 4, 7};
    private static final int[] percussion = new int[]{9, 6, 4, 4, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 7, 2, 7, 7, 6, 3, 7, 6, 7, 3, 7, 2, 2, 3, 3, 3, 2, 2, 6, 6, 2, 2, 0, 0, 3, 3, 3, 3, 3, 3, 5, 5, 10, 10};

    private static void playMidi(Sequence sequence, float tempo, String ID, Player ... listeners) {
        try {
            Sequencer sequencer = MidiSystem.getSequencer(false);
            sequencer.setSequence(sequence);
            sequencer.open();
            sequencer.setTempoFactor(tempo);
            NoteBlockReceiver reciever = new NoteBlockReceiver(ID, listeners);
            sequencer.getTransmitter().setReceiver(reciever);
            sequencer.start();
            playing.put(ID.toLowerCase(), sequencer);
        }
        catch (InvalidMidiDataException | MidiUnavailableException e) {
            Skript.exception((Throwable)e, (String[])new String[]{"Error attempting to play a midi file"});
        }
    }

    public static void playMidi(File file, float tempo, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidi(MidiSystem.getSequence(file), tempo, ID, listeners);
    }

    public static void playMidi(InputStream stream, float tempo, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidi(MidiSystem.getSequence(stream), tempo, ID, listeners);
    }

    public static void playMidiQuietly(File file, float tempo, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidi(file, tempo, ID, listeners);
    }

    public static void playMidiQuietly(InputStream stream, float tempo, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidi(stream, tempo, ID, listeners);
    }

    public static void playMidiQuietly(File file, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidiQuietly(file, 1.0f, ID, listeners);
    }

    public static void playMidiQuietly(InputStream stream, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidiQuietly(stream, 1.0f, ID, listeners);
    }

    public static boolean isPlaying(String ID) {
        return playing.containsKey(ID);
    }

    public static void stop(String ID) {
        String id = ID.toLowerCase();
        if (playing.containsKey(id)) {
            Sequencer sequencer = playing.get(id);
            try {
                sequencer.getReceiver().close();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
            sequencer.stop();
            sequencer.close();
            playing.remove(id);
        }
    }

    private static byte bytePercussion(Integer patch) {
        if (patch == null) {
            return 0;
        }
        int i = patch - 33;
        if (i < 0 || i >= percussion.length) {
            return 1;
        }
        return (byte)percussion[i];
    }

    private static byte byteInstrument(Integer patch) {
        if (patch == null) {
            return 0;
        }
        if (patch < 0 || patch >= instruments.length) {
            return 0;
        }
        return (byte)instruments[patch];
    }

    public static Sound patchToPercussion(int patch) {
        return Instrument.fromByte(MidiUtil.bytePercussion(patch)).getSound();
    }

    public static Sound patchToInstrument(int patch) {
        return Instrument.fromByte(MidiUtil.byteInstrument(patch)).getSound();
    }
}

