/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.Reflection;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.event.Event;

@Name(value="Clear Single Recipes")
@Description(value="Clears all recipes for a single item.")
@Examples(value={"on script load:;->wipe crafting recipes for stick and iron pickaxe"})
@Patterns(value={"wipe crafting recipes for %itemtypes%"})
public class EffClearItemRecipes
extends Effect {
    private Expression<ItemType> items;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = expressions[0];
        return true;
    }

    protected void execute(Event event) {
        for (ItemType type : (ItemType[])this.items.getArray(event)) {
            try {
                Object craftingInstance = Reflection.getNMSClass("CraftingManager").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                Object recipes = Reflection.getField(craftingInstance.getClass(), "recipes").get(craftingInstance);
                Reflection.getMethod(recipes.getClass(), "remove", new Class[0]).invoke(recipes, type.getRandom().getType().getId());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString(Event event, boolean debug) {
        return "clear recipes " + this.items.toString(event, debug);
    }
}

