/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.note.MidiUtil;
import org.bukkit.event.Event;

@Name(value="Midi is playing")
@Description(value="Checks whether or not a midi ID is playing.")
@Patterns(value={"midi [ids] %strings% (are|is) playing", "midi [ids] %strings% (are|is)(n't| not) playing"})
public class CondMidi
extends Condition {
    private Expression<String> ID;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.ID = expressions[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.ID.check(event, (Checker)new Checker<String>(){

            public boolean check(String title) {
                return MidiUtil.isPlaying(title);
            }
        }, this.isNegated());
    }

    public String toString(Event event, boolean debug) {
        return "midi " + this.ID.toString(event, debug) + " is playing";
    }
}

