/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.elements.events.bukkit.AttachedTabCompleteEvent;
import com.w00tmast3r.skquery.util.Collect;
import java.util.List;
import org.bukkit.event.Event;

@Patterns(value={"[tab] (completions|suggestions)"})
public class ExprTabCompletions
extends SimpleExpression<String> {
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(AttachedTabCompleteEvent.class)) {
            Skript.error((String)"Tab completers can only be accessed from tab complete events.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected String[] get(Event event) {
        List<String> completions = ((AttachedTabCompleteEvent)event).getResult();
        return completions.toArray(new String[completions.size()]);
    }

    public String toString(Event e, boolean debug) {
        return "tab results";
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD) {
            return Collect.asArray(String.class);
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String node = delta[0] == null ? "" : (String)delta[0];
        AttachedTabCompleteEvent event = (AttachedTabCompleteEvent)e;
        if (node.toLowerCase().startsWith(event.getArgs()[event.getArgs().length - 1].toLowerCase())) {
            event.getResult().add(node);
        }
    }
}

