/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Timespan;
import com.w00tmast3r.skquery.api.PropertyFrom;
import com.w00tmast3r.skquery.api.PropertyTo;
import com.w00tmast3r.skquery.api.UsePropertyPatterns;
import com.w00tmast3r.skquery.util.Collect;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@UsePropertyPatterns
@PropertyFrom(value="worldborders")
@PropertyTo(value="[world[ ]border[s]] warning time")
public class ExprBorderWarningTime
extends SimplePropertyExpression<WorldBorder, Number> {
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "warning time";
    }

    @Nullable
    public Number convert(WorldBorder border) {
        return border.getWarningTime();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return Collect.asArray(Timespan.class);
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        Timespan timespan = (Timespan)delta[0];
        Long time = timespan.getMilliSeconds() / 1000L;
        switch (mode) {
            case SET: {
                for (WorldBorder border : (WorldBorder[])this.getExpr().getArray(event)) {
                    border.setWarningTime(((Number)time).intValue());
                }
                break;
            }
            case ADD: {
                for (WorldBorder border : (WorldBorder[])this.getExpr().getArray(event)) {
                    int warning = border.getWarningTime();
                    border.setWarningTime(warning + ((Number)time).intValue());
                }
                break;
            }
            case REMOVE: {
                for (WorldBorder border : (WorldBorder[])this.getExpr().getArray(event)) {
                    int warning = border.getWarningTime();
                    border.setWarningTime(warning - ((Number)time).intValue());
                }
                break;
            }
        }
    }
}

