/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.PropertyFrom;
import com.w00tmast3r.skquery.api.PropertyTo;
import com.w00tmast3r.skquery.api.UsePropertyPatterns;
import com.w00tmast3r.skquery.util.Collect;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@UsePropertyPatterns
@PropertyFrom(value="worldborders")
@PropertyTo(value="[world[ ]border[s]] (size|diameter) [over [a [(time|period) of]] %-timespan%]")
public class ExprBorderSize
extends PropertyExpression<WorldBorder, Number> {
    private Expression<Timespan> timespan;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[1 - matchedPattern]);
        this.timespan = exprs[matchedPattern];
        return true;
    }

    protected Number[] get(Event event, WorldBorder[] source) {
        return (Number[])this.get(source, border -> border.getSize());
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "size of world borders " + this.getExpr().toString(event, debug) + " over time " + this.timespan.toString(event, debug);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return Collect.asArray(Number.class);
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null || this.timespan == null) {
            return;
        }
        Timespan time = (Timespan)this.timespan.getSingle(event);
        double amount = ((Number)delta[0]).doubleValue();
        long milliseconds = time == null ? -1L : time.getMilliSeconds() / 1000L;
        switch (mode) {
            case SET: {
                for (WorldBorder border : (WorldBorder[])this.getExpr().getArray(event)) {
                    if (milliseconds == -1L) {
                        border.setSize(amount);
                        continue;
                    }
                    border.setSize(amount, milliseconds);
                }
                break;
            }
            case ADD: {
                for (WorldBorder border : (WorldBorder[])this.getExpr().getArray(event)) {
                    double size = border.getSize();
                    if (milliseconds == -1L) {
                        border.setSize(size + amount);
                        continue;
                    }
                    border.setSize(size + amount, milliseconds);
                }
                break;
            }
            case REMOVE: {
                for (WorldBorder border : (WorldBorder[])this.getExpr().getArray(event)) {
                    double size = border.getSize();
                    if (milliseconds == -1L) {
                        border.setSize(size - amount);
                        continue;
                    }
                    border.setSize(size - amount, milliseconds);
                }
                break;
            }
        }
    }
}

