/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.skript.Markup;
import org.bukkit.event.Event;

@Name(value="Evaluate Input Effect")
@Description(value="Runs the input string relative to the calling trigger which invoked it.")
@Examples(value={"command /effectcommand <text>:;->trigger:;->->evaluate argument"})
@Patterns(value={"evaluate %string/markup%", "^%markup%"})
public class EffEvaluateEffect
extends Effect {
    private Expression<?> effect;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.effect = expressions[0];
        return true;
    }

    protected void execute(Event event) {
        String pre = null;
        Object object = this.effect.getSingle(event);
        if (object instanceof String) {
            pre = (String)object;
        } else if (object instanceof Markup) {
            pre = object.toString();
        }
        if (pre == null) {
            return;
        }
        ScriptLoader.setCurrentEvent((String)"this", (Class[])new Class[]{event.getClass()});
        Effect e = Effect.parse((String)pre, null);
        ScriptLoader.deleteCurrentEvent();
        if (e == null) {
            return;
        }
        e.run(event);
    }

    public String toString(Event event, boolean debug) {
        return "evaluate " + this.effect.toString(event, debug);
    }
}

