/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.effects.EffSpawn;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.Reflection;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Location;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Spawn Falling Block")
@Description(value="Summons falling blocks with modifiable properties.")
@Examples(value={"on place of dirt:", "\tcancel event", "\tspawn falling block of dirt at block"})
@Patterns(value={"spawn falling block of %itemtype% at %locations%", "spawn damaging falling block of %itemtype% at %locations%", "spawn undroppable falling block of %itemtype% at %locations%", "spawn damaging undroppable falling block of %itemtype% at %locations%", "spawn undroppable damaging falling block of %itemtype% at %locations%"})
public class EffBlockFall
extends Effect {
    private Expression<Location> locations;
    private Expression<ItemType> type;
    private boolean breaks;
    private boolean damages;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = expressions[0];
        this.locations = expressions[1];
        this.damages = matchedPattern == 1 || matchedPattern == 3 || matchedPattern == 4;
        this.breaks = matchedPattern == 2 || matchedPattern == 3 || matchedPattern == 4;
        return true;
    }

    protected void execute(Event event) {
        ItemType item = (ItemType)this.type.getSingle(event);
        if (item == null) {
            return;
        }
        for (Location location : (Location[])this.locations.getArray(event)) {
            for (ItemStack itemstack : item.getAll()) {
                FallingBlock block = location.getWorld().spawnFallingBlock(location, itemstack.getType().createBlockData());
                EffSpawn.lastSpawned = block;
                if (this.damages) {
                    try {
                        Object craftSand = Reflection.getOBCClass("entity.CraftFallingSand").getMethod("getHandle", new Class[0]).invoke((Object)block, new Object[0]);
                        craftSand.getClass().getMethod("a", Boolean.TYPE).invoke(craftSand, true);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                if (!this.breaks) continue;
                block.setDropItem(false);
            }
        }
    }

    public String toString(Event event, boolean debug) {
        return "falling block " + this.type.toString(event, debug);
    }
}

