/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.Location;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;

@Name(value="Within Border")
@Description(value="Checks whether or not a location is within the WorldBorder.")
@Patterns(value={"%locations% is [with]in [world[ ]border[s]] %worldborder%", "%locations% (isn't|is not) [with]in [world[ ]border[s]] %worldborder%"})
public class CondWithinBorder
extends Condition {
    private Expression<WorldBorder> worldBorder;
    private Expression<Location> locations;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.locations = expressions[0];
        this.worldBorder = expressions[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        WorldBorder border = (WorldBorder)this.worldBorder.getSingle(event);
        return this.locations.check(event, location -> border.isInside(location), this.isNegated());
    }

    public String toString(Event event, boolean debug) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.CAN, (Event)event, (boolean)debug, this.locations, (String)(" are within border " + this.worldBorder.toString(event, debug)));
    }
}

