/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffectType;

@Name(value="Entity has Potion")
@Description(value="Checks whether or not an entity has a certain potion effect.")
@Patterns(value={"%livingentities% (has|have) [potion [effect]] %potioneffecttypes%", "%livingentities% (doesn't|does not|do not|don't) have [potion [effect]] %potioneffecttypes%"})
public class CondHasPotion
extends Condition {
    private Expression<PotionEffectType> effects;
    private Expression<LivingEntity> entities;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = expressions[0];
        this.effects = expressions[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.entities.check(event, entity -> this.effects.check(event, effect -> entity.hasPotionEffect(effect)), this.isNegated());
    }

    public String toString(Event event, boolean debug) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (Event)event, (boolean)debug, this.entities, (String)("effects " + this.effects.toString(event, debug)));
    }
}

