/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.note.MidiUtil;
import org.bukkit.event.Event;

@Name(value="Stop MIDI")
@Description(value="Stops a midi file that is playing.")
@Examples(value={"on join:", "\tplay midi \"login\" to player", "\twait 5 seconds", "\tstop midi \"login\""})
@Patterns(value={"stop midi [id] %string%"})
public class EffMIDIStop
extends Effect {
    private Expression<String> ID;

    public boolean init(Expression<?>[] expressions, int markedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.ID = expressions[0];
        return true;
    }

    protected void execute(Event event) {
        String track = (String)this.ID.getSingle(event);
        if (track == null) {
            return;
        }
        if (MidiUtil.isPlaying(track)) {
            MidiUtil.stop(track);
        }
    }

    public String toString(Event event, boolean debug) {
        return "stop midi " + this.ID.toString(event, debug);
    }
}

