/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

@Name(value="Leash Entities")
@Description(value="Cause multiple entities to leash other entities.")
@Examples(value={"on click:;->make player leash clicked entity"})
@Patterns(value={"make %entities% (leash|lead) %livingentities%", "(leash|lead) %livingentities% to %entities%"})
public class EffLeash
extends Effect {
    private Expression<Entity> holders;
    private Expression<LivingEntity> targets;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holders = expressions[matchedPattern];
        this.targets = expressions[1 - matchedPattern];
        return true;
    }

    protected void execute(Event event) {
        for (Entity entity : (Entity[])this.holders.getArray(event)) {
            for (LivingEntity living : (LivingEntity[])this.targets.getArray(event)) {
                living.setLeashHolder(entity);
            }
        }
    }

    public String toString(Event event, boolean debug) {
        return "leash " + this.targets.toString(event, debug) + " to " + this.holders.toString(event, debug);
    }
}

