/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.menus.FormattedSlotManager;
import com.w00tmast3r.skquery.util.menus.SlotRule;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

@Name(value="Format Inventory Slot")
@Description(value="Formats a slot in the player's open inventory to do certain actions. This should be done directly after showing an inventory to the player.")
@Examples(value={"command /construct:;->trigger:;->->open chest with 1 rows named \"&4My first test menu\" to player;->->format slot 0 of player with 5 of steak named \"Item 1\" to close then run \"say The first item was clicked! Menu Closed!\";->->format slot 2 of player with fire named \"Close Menu\" with lore \"I will close this menu.||Nothing more, nothing less.\" to close"})
@Patterns(value={"format slot %number% of %players% with %itemstack% to close then run %string/lambda%", "format slot %number% of %players% with %itemstack% to run %string/lambda%", "format slot %number% of %players% with %itemstack% to close", "format slot %number% of %players% with %itemstack% to (be|act) unstealable", "unformat slot %number% of %players%"})
public class EffFormatSlot
extends Effect {
    private Expression<Player> targets;
    private Expression<ItemStack> item;
    private Expression<Number> slot;
    private Expression<?> callback;
    private int action;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.slot = expressions[0];
        this.targets = expressions[1];
        if (matchedPattern <= 3) {
            this.item = expressions[2];
        }
        if (matchedPattern <= 1) {
            this.callback = expressions[3];
        }
        this.action = matchedPattern;
        return true;
    }

    protected void execute(Event event) {
        SlotRule toClone;
        Number s = (Number)this.slot.getSingle(event);
        if (s == null) {
            return;
        }
        ItemStack i = null;
        switch (this.action) {
            case 0: {
                Object c = this.callback.getSingle(event);
                i = (ItemStack)this.item.getSingle(event);
                if (c == null) {
                    return;
                }
                toClone = new SlotRule(c, true);
                break;
            }
            case 1: {
                Object c = this.callback.getSingle(event);
                i = (ItemStack)this.item.getSingle(event);
                if (c == null) {
                    return;
                }
                toClone = new SlotRule(c, false);
                break;
            }
            case 2: {
                i = (ItemStack)this.item.getSingle(event);
                if (i == null) {
                    return;
                }
                toClone = new SlotRule(null, true);
                break;
            }
            case 3: {
                i = (ItemStack)this.item.getSingle(event);
                toClone = new SlotRule(null, false);
                break;
            }
            case 4: {
                for (Player p : (Player[])this.targets.getArray(event)) {
                    FormattedSlotManager.removeRule(p, s.intValue());
                }
                return;
            }
            default: {
                return;
            }
        }
        if (i != null) {
            for (Player p : (Player[])this.targets.getArray(event)) {
                if (p.getOpenInventory().getType() == InventoryType.CRAFTING) continue;
                p.getOpenInventory().setItem(s.intValue(), i);
            }
        }
        for (Player p : (Player[])this.targets.getArray(event)) {
            if (p.getOpenInventory().getType() == InventoryType.CRAFTING) continue;
            FormattedSlotManager.addRule(event, p, s.intValue(), toClone.clone());
        }
    }

    public String toString(Event event, boolean b) {
        return "format slot";
    }
}

