/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.event.Event;

@Name(value="Is Divisible")
@Description(value="Checks whether or not a number can be divided into another number.")
@Patterns(value={"%number% is divisible by %number%", "%number% is not divisible by %number%"})
public class CondIsDivisible
extends Condition {
    private Expression<Number> number;
    private Expression<Number> divisible;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.number = expressions[0];
        this.divisible = expressions[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(final Event event) {
        return this.number.check(event, (Checker)new Checker<Number>(){

            public boolean check(Number in) {
                return in.floatValue() % ((Number)CondIsDivisible.this.divisible.getSingle(event)).floatValue() == 0.0f;
            }
        }, this.isNegated());
    }

    public String toString(Event event, boolean debug) {
        return this.number.toString(event, debug) + " is divisible by " + this.divisible.toString(event, debug);
    }
}

