/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Patterns;
import java.io.File;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="File existance")
@Description(value={"Checks whether or not a file at the defined path(s) exist."})
@Patterns(value={"file %string% (1\u00a6does|2\u00a6does(n't| not)) exist", "existance of [file] %string% is %boolean%"})
public class CondFileExistance
extends Condition {
    private Expression<Boolean> check;
    private Expression<String> files;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.files = expressions[0];
        this.setNegated(parseResult.mark == 1);
        if (expressions.length > 1) {
            this.check = expressions[0];
        }
        return true;
    }

    public boolean check(Event event) {
        if (this.files == null) {
            return !this.isNegated();
        }
        Boolean negated = this.check != null ? (Boolean)this.check.getSingle(event) : Boolean.valueOf(this.isNegated());
        File file = new File((String)this.files.getSingle(event));
        return file.exists() ? negated : negated == false;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "file existance" + this.files != null ? this.files.toString(event, debug) : "";
    }
}

